/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.text;

import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.set.basis.constants.TextType;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.text.AttributeRule;
import org.eclipse.set.utils.text.DescriptionToResourceTransformation;
import org.eclipse.set.utils.text.PlanProReconcileStrategy;
import org.eclipse.set.utils.text.TagRule;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class ToolboxViewerConfiguration
extends TextSourceViewerConfiguration {
    private static final String ATTRIBUTE_DEFAULTS = "red,white,normal";
    private static final String DEFAULT_DEFAULTS = "black,white,bold";
    private static final String STRING_DEFAULTS = "dark_magenta,white,bold";
    private static final String TAG_DEFAULTS = "dark_blue,white,normal";
    private final Composite parent;
    private PlanProReconcileStrategy strategy;
    private final DescriptionToResourceTransformation stringToTextAttributeTransformation;
    private final UISynchronize sync;

    private static void addDamagerRepairer(PresentationReconciler reconciler, RuleBasedScanner scanner, String contentType) {
        DefaultDamagerRepairer damagerRepairer = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)damagerRepairer, contentType);
        reconciler.setRepairer((IPresentationRepairer)damagerRepairer, contentType);
    }

    public ToolboxViewerConfiguration(Composite parent, DescriptionToResourceTransformation stringToTextAttributeTransformation, UISynchronize sync) {
        this.parent = parent;
        this.stringToTextAttributeTransformation = stringToTextAttributeTransformation;
        this.sync = sync;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        ToolboxViewerConfiguration.addDamagerRepairer(reconciler, this.createPlanProScanner(), "__dftl_partition_content_type");
        return reconciler;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        this.strategy = new PlanProReconcileStrategy((ProjectionViewer)sourceViewer, this.sync);
        return new MonoReconciler((IReconcilingStrategy)this.getStrategy(), false);
    }

    private RuleBasedScanner createPlanProScanner() {
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setDefaultReturnToken(this.getDefaultToken());
        TagRule tagRule = new TagRule(this.getTagToken());
        IRule[] rules = new IRule[]{this.createStringRule1(), this.createStringRule2(), tagRule, new AttributeRule(tagRule, this.getAttributeToken())};
        scanner.setRules(rules);
        return scanner;
    }

    private IRule createStringRule1() {
        PatternRule rule = new PatternRule("\"", "\"", this.getStringToken(), '\\', true);
        return rule;
    }

    private IRule createStringRule2() {
        PatternRule rule = new PatternRule("'", "'", this.getStringToken(), '\\', true);
        return rule;
    }

    private IToken getAttributeToken() {
        String textAttributeString = ToolboxConfiguration.getTextAttribute(TextType.TOOLBOX_VIEWER_ATTRIBUTES, ATTRIBUTE_DEFAULTS, this.parent);
        TextAttribute textAttribute = this.stringToTextAttributeTransformation.transformToTextAttribute(textAttributeString);
        return new Token((Object)textAttribute);
    }

    private IToken getDefaultToken() {
        String textAttributeString = ToolboxConfiguration.getTextAttribute(TextType.TOOLBOX_VIEWER_DEFAULTS, DEFAULT_DEFAULTS, this.parent);
        TextAttribute textAttribute = this.stringToTextAttributeTransformation.transformToTextAttribute(textAttributeString);
        return new Token((Object)textAttribute);
    }

    private synchronized PlanProReconcileStrategy getStrategy() {
        return this.strategy;
    }

    private IToken getStringToken() {
        String textAttributeString = ToolboxConfiguration.getTextAttribute(TextType.TOOLBOX_VIEWER_STRINGS, STRING_DEFAULTS, this.parent);
        TextAttribute textAttribute = this.stringToTextAttributeTransformation.transformToTextAttribute(textAttributeString);
        return new Token((Object)textAttribute);
    }

    private IToken getTagToken() {
        String textAttributeString = ToolboxConfiguration.getTextAttribute(TextType.TOOLBOX_VIEWER_TAGS, TAG_DEFAULTS, this.parent);
        TextAttribute textAttribute = this.stringToTextAttributeTransformation.transformToTextAttribute(textAttributeString);
        return new Token((Object)textAttribute);
    }
}

