/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Colors {
    public static final ColorDescriptor DEFAULT_GREYEDOUT_COLOR;
    private static final String BLUE = "blue";
    private static final String DESCRIPTION_FORMAT = "%d,%d,%d";
    private static final String DESCRIPTION_PATTERN = "(?<red>[0-9]+),(?<green>[0-9]+),(?<blue>[0-9]+)";
    private static final String GREEN = "green";
    private static final String RED = "red";

    static {
        RGB defaultGreyedoutRgb = new RGB(242, 242, 242);
        DEFAULT_GREYEDOUT_COLOR = ColorDescriptor.createFrom((RGB)defaultGreyedoutRgb);
    }

    public static ColorDescriptor keyToDescriptor(String key) {
        RGB rgb = Colors.keyToRGB(key);
        return ColorDescriptor.createFrom((RGB)rgb);
    }

    public static ColorDescriptor keyToDescriptor(String key, Color defaultColor) {
        RGB rgb = Colors.keyToRGB(key, defaultColor);
        return ColorDescriptor.createFrom((RGB)rgb);
    }

    public static RGB keyToRGB(String key) {
        String value = System.getProperty(key, Colors.toDescription(Display.getDefault().getSystemColor(2)));
        return Colors.parseRGB(value);
    }

    public static RGB keyToRGB(String key, Color defaultColor) {
        String value = System.getProperty(key, Colors.toDescription(defaultColor));
        return Colors.parseRGB(value);
    }

    public static RGB parseRGB(String value) {
        Pattern pattern = Pattern.compile(DESCRIPTION_PATTERN);
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            int red = Integer.parseInt(matcher.group(RED));
            int green = Integer.parseInt(matcher.group(GREEN));
            int blue = Integer.parseInt(matcher.group(BLUE));
            return new RGB(red, green, blue);
        }
        throw new IllegalArgumentException(value + " does not match pattern \"(?<red>[0-9]+),(?<green>[0-9]+),(?<blue>[0-9]+)\"");
    }

    public static String toDescription(Color color) {
        RGB rgb = color.getRGB();
        return String.format(DESCRIPTION_FORMAT, rgb.red, rgb.green, rgb.blue);
    }
}

