/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Abstand_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante_Allg_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Laenge_TypeClass;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;

@Component
public class PunktObjektTOPKante
extends AbstractPlazContainerCheck
implements PlazCheck {
    @Override
    public List<PlazError> run(MultiContainer_AttributeGroup container) {
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, PlazError> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, PlazError>(){

            public PlazError apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                boolean _greaterThan;
                boolean _lessThan;
                Abstand_TypeClass _abstand = it.getAbstand();
                BigDecimal _wert = null;
                if (_abstand != null) {
                    _wert = _abstand.getWert();
                }
                BigDecimal distance = _wert;
                TOP_Kante _topKante = PunktObjektTopKanteExtensions.getTopKante((Punkt_Objekt_TOP_Kante_AttributeGroup)it);
                TOP_Kante_Allg_AttributeGroup _tOPKanteAllg = null;
                if (_topKante != null) {
                    _tOPKanteAllg = _topKante.getTOPKanteAllg();
                }
                TOP_Laenge_TypeClass _tOPLaenge = null;
                if (_tOPKanteAllg != null) {
                    _tOPLaenge = _tOPKanteAllg.getTOPLaenge();
                }
                BigDecimal _wert_1 = null;
                if (_tOPLaenge != null) {
                    _wert_1 = _tOPLaenge.getWert();
                }
                BigDecimal topLength = _wert_1;
                if (distance == null || topLength == null) {
                    return null;
                }
                String generalErroMsg = PunktObjektTOPKante.this.transformErrorMsg(Map.of("Distance", distance.toString()));
                double _doubleValue = distance.doubleValue();
                boolean bl = _lessThan = _doubleValue < 0.0;
                if (_lessThan) {
                    PlazError err = PlazFactory.eINSTANCE.createPlazError();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(generalErroMsg);
                    _builder.append(" Der Punktobjektabstand darf nicht negativ sein.");
                    err.setMessage(_builder.toString());
                    err.setType(PunktObjektTOPKante.this.checkType());
                    err.setObject((EObject)it);
                    return err;
                }
                boolean bl2 = _greaterThan = distance.compareTo(topLength) > 0;
                if (_greaterThan) {
                    PlazError err_1 = PlazFactory.eINSTANCE.createPlazError();
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append(generalErroMsg);
                    _builder_1.append(" L\u00e4nge TOP-Kante: ");
                    _builder_1.append((Object)topLength);
                    _builder_1.append(".");
                    err_1.setMessage(_builder_1.toString());
                    err_1.setType(PunktObjektTOPKante.this.checkType());
                    err_1.setObject((EObject)it);
                    return err_1;
                }
                return null;
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)container.getAllContents(), Punkt_Objekt_TOP_Kante_AttributeGroup.class), (Functions.Function1)_function)));
    }

    @Override
    public String checkType() {
        return "Punktobjektabstand";
    }

    @Override
    public String getDescription() {
        return "Der Punktobjektabstand aller LST-Objekte ist g\u00fcltig.";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Ung\u00fcltiger Punktobjektabstand f\u00fcr LST-Objekt Abstand: {Distance}.";
    }

    private String transformErrorMsg(Map<String, String> params) {
        return StringSubstitutor.replace((Object)this.getGeneralErrMsg(), params, (String)"{", (String)"}");
    }
}

