/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.overviewplan.parts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Paths;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emfcloud.jackson.module.EMFModule;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.set.browser.RequestHandler;
import org.eclipse.set.feature.overviewplan.transformator.OverviewplanTransformator;
import org.eclipse.set.feature.siteplan.json.SiteplanEObjectSerializer;
import org.eclipse.set.model.siteplan.Siteplan;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.FileWebBrowser;
import org.eclipse.swt.widgets.Composite;

public class WebOverviewplanPart
extends BasePart {
    private static final String WEB_PATH = "./web/siteplan";
    @Inject
    IEclipseContext context;

    private void serveOverviewplan(RequestHandler.Response response) throws JsonProcessingException {
        OverviewplanTransformator overviewplanTransformator = (OverviewplanTransformator)this.context.get(OverviewplanTransformator.class);
        Siteplan siteplan = overviewplanTransformator.transform(this.getModelSession());
        ObjectMapper mapper = new ObjectMapper();
        EMFModule module = new EMFModule();
        module.configure(EMFModule.Feature.OPTION_SERIALIZE_TYPE, false);
        module.configure(EMFModule.Feature.OPTION_SERIALIZE_DEFAULT_VALUE, true);
        mapper.registerModule((Module)module);
        mapper.registerModule((Module)SiteplanEObjectSerializer.getModule((EMFModule)module));
        String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)siteplan);
        response.setMimeType("application/json;charset=UTF-8");
        response.setResponseData(json);
    }

    protected void createView(Composite parent) {
        try {
            FileWebBrowser browser = new FileWebBrowser(parent);
            GridDataFactory.swtDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo(browser.getControl());
            browser.serveRootDirectory(Paths.get(WEB_PATH, new String[0]));
            browser.serveFile("?", "text/html", Paths.get(WEB_PATH, "index.html"));
            browser.serveUri("siteplan.json", this::serveOverviewplan);
            browser.setUrl("https://toolbox/?");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

