/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.browser.cef;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.set.browser.RequestHandler;
import org.eclipse.set.browser.WebBrowser;
import org.eclipse.set.browser.cef.AuthDialog;
import org.eclipse.set.browser.cef.CEFFactory;
import org.eclipse.set.browser.cef.ChromiumStatic;
import org.eclipse.set.browser.cef.handlers.ResourceHandler;
import org.eclipse.set.browser.cef.handlers.StringVisitor;
import org.eclipse.set.browser.cef.handlers.browser.ClientHandler;
import org.eclipse.set.browser.cef.handlers.browser.PopupClientHandler;
import org.eclipse.set.browser.lib.ChromiumLib;
import org.eclipse.set.browser.lib.FunctionSt;
import org.eclipse.set.browser.lib.cef_browser_t;
import org.eclipse.set.browser.lib.cef_popup_features_t;
import org.eclipse.set.browser.swt.Browser;
import org.eclipse.set.browser.swt.BrowserFunction;
import org.eclipse.set.browser.swt.OpenWindowListener;
import org.eclipse.set.browser.swt.WindowEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.AuthenticationListener;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Chromium
extends WebBrowser {
    private static final String DATA_TEXT_URL = "data:text/html;base64,";
    private static int EVAL = 1;
    private static final int LOOP = 75;
    private static final int MAX_PROGRESS = 100;
    private static final String SET_TEXT_URL = "swt.chromium.setText.";
    private long browser;
    private int browserId;
    private boolean canGoBack;
    private boolean canGoForward;
    private ClientHandler clientHandler;
    private final CompletableFuture<Boolean> created = new CompletableFuture();
    private Dispose disposing = Dispose.No;
    private CompletableFuture<Boolean> enableProgress = new CompletableFuture();
    private FocusListener focusListener;
    private boolean hasFocus;
    private String[] headers;
    private long hwnd;
    private boolean ignoreFirstFocus = true;
    private WindowEvent isPopup;
    private PaintListener paintListener;
    private String postData;
    private String text = "";
    private final CompletableFuture<Boolean> textReady = new CompletableFuture();
    private StringVisitor textVisitor;
    private String url;
    Browser chromium;
    int instance;
    PopupClientHandler popupClientHandler;

    private static int cefColor(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b << 0;
    }

    private static String getPlainUrl(String url) {
        if (url != null && url.startsWith(DATA_TEXT_URL)) {
            return url.substring(0, DATA_TEXT_URL.length() - 8);
        }
        if (url != null && url.startsWith("file:/") && url.contains(SET_TEXT_URL)) {
            return "about:blank";
        }
        return url;
    }

    protected static long getHandle(Composite control) {
        return control.handle;
    }

    static long checkGetAddress(Callback cb) {
        long address = cb.getAddress();
        if (address == 0L) {
            throw new SWTError(3);
        }
        return address;
    }

    static void disposeCallback(Callback cb) {
        if (cb != null) {
            cb.dispose();
        }
    }

    static void doSetUrlPost(long browser_id, String url, String postData, String[] headers) {
        byte[] bytes = postData != null ? postData.getBytes(Charset.forName("ASCII")) : null;
        int bytesLength = bytes != null ? bytes.length : 0;
        int headersLength = headers != null ? headers.length : 0;
        String joinHeaders = headers == null ? null : String.join((CharSequence)"::", headers);
        cef_browser_t.cefswt_load_url((long)browser_id, (String)url, (byte[])bytes, (int)bytesLength, (String)joinHeaders, (int)headersLength);
    }

    static void freeDelayed(long ptr) {
        Display.getDefault().asyncExec(() -> C.free((long)ptr));
    }

    @Override
    public boolean back() {
        if (this.canGoBack) {
            ChromiumLib.cefswt_go_back((long)this.browser);
            return true;
        }
        return false;
    }

    @Override
    public boolean close() {
        if (this.disposing != Dispose.No || this.isDisposed()) {
            return false;
        }
        if (this.browser == 0L) {
            return true;
        }
        boolean closed = false;
        this.disposing = Dispose.FromClose;
        cef_browser_t.cefswt_close_browser((long)this.browser, (int)0);
        long t = System.currentTimeMillis();
        long end = t + 10000L;
        Shell shell = this.chromium.getShell();
        Display display = shell.getDisplay();
        while (!shell.isDisposed() && System.currentTimeMillis() < end) {
            if (this.disposing == Dispose.Unload) {
                end += 1000L;
            } else if (this.disposing == Dispose.UnloadClosed) {
                this.disposing = Dispose.WaitIfClosed;
                end = System.currentTimeMillis() + 150L;
            } else if (this.disposing == Dispose.DoIt) {
                closed = true;
                break;
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (!closed) {
            this.disposing = Dispose.No;
        }
        return closed;
    }

    @Override
    public void create(Composite parent, int style) {
        ChromiumStatic.initCEF(this.chromium.getDisplay());
        this.textVisitor = new StringVisitor(str -> {
            String string = this.text = str;
        }, this.textReady);
        this.clientHandler = new ClientHandler(this);
        this.popupClientHandler = new PopupClientHandler();
        this.chromium.setBackground(parent.getDisplay().getSystemColor(37));
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Chromium.this.chromium.removePaintListener(this);
                Chromium.this.createBrowser();
                Chromium.this.paintListener = null;
            }
        };
        this.chromium.addPaintListener(this.paintListener);
    }

    @Override
    public void createFunction(BrowserFunction function) {
        this.created.thenRun(() -> {
            this.checkBrowser();
            for (BrowserFunction current : this.functions.values()) {
                if (!current.name.equals(browserFunction.name)) continue;
                this.deregisterFunction(current);
                break;
            }
            browserFunction.index = this.getNextFunctionIndex();
            this.registerFunction(function);
            cef_browser_t.cefswt_function((long)this.browser, (String)browserFunction.name, (int)browserFunction.index);
        });
    }

    @Override
    public void destroyFunction(BrowserFunction function) {
        this.checkBrowser();
        this.deregisterFunction(function);
    }

    public void dispose() {
        if (this.disposing == Dispose.FromDispose || this.isDisposed()) {
            return;
        }
        boolean callClose = this.disposing == Dispose.No;
        this.disposing = Dispose.FromDispose;
        ++ChromiumStatic.disposingAny;
        if (this.focusListener != null) {
            this.chromium.removeFocusListener(this.focusListener);
        }
        this.focusListener = null;
        if (this.browser != 0L && callClose) {
            cef_browser_t.cefswt_close_browser((long)this.browser, (int)1);
            this.waitForClose(Display.getDefault());
        }
    }

    @Override
    public Object evaluate(String script) throws SWTException {
        if (!this.jsEnabled) {
            return null;
        }
        if (this.browser == 0L && this.paintListener != null) {
            this.chromium.removePaintListener(this.paintListener);
            this.paintListener = null;
            this.createBrowser();
        }
        this.checkBrowser();
        Object[] ret = new Object[1];
        EvalReturned callback = (loop, type, valuePtr) -> {
            if (loop == 1) {
                this.chromium.getDisplay().readAndDispatch();
            } else {
                String value = ChromiumLib.cefswt_cstring_to_java((long)valuePtr);
                objectArray[0] = this.mapType(type, value);
            }
        };
        Callback callback_cb = new Callback((Object)callback, "invoke", Void.TYPE, new Type[]{Integer.TYPE, Integer.TYPE, Long.TYPE});
        StringBuilder buffer = new StringBuilder("(function() {");
        buffer.append("\n");
        buffer.append(script);
        buffer.append("\n})()");
        boolean returnSt = cef_browser_t.cefswt_eval((long)this.browser, (String)buffer.toString(), (int)EVAL++, (long)Chromium.checkGetAddress(callback_cb));
        Chromium.disposeCallback(callback_cb);
        if (!returnSt) {
            throw new SWTException("Script that was evaluated failed");
        }
        return ret[0];
    }

    @Override
    public boolean execute(String script) {
        if (!this.jsEnabled) {
            return false;
        }
        this.enableProgress.thenRun(() -> cef_browser_t.cefswt_execute((long)this.browser, (String)script));
        return true;
    }

    @Override
    public boolean forward() {
        if (this.canGoForward) {
            ChromiumLib.cefswt_go_forward((long)this.browser);
            return true;
        }
        return false;
    }

    public int get_auth_credentials(long browser_id2, long origin_url, long host, int port, long realm, long callback) {
        if (this.isDisposed()) {
            return 0;
        }
        AuthenticationEvent event = new AuthenticationEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.doit = true;
        String protocol = "http";
        try {
            URL u = new URL(this.url);
            protocol = u.getProtocol();
        }
        catch (MalformedURLException e) {
            return 0;
        }
        String hostStr = host != 0L ? ChromiumLib.cefswt_cefstring_to_java((long)host) : "";
        String realmStr = realm != 0L ? ChromiumLib.cefswt_cefstring_to_java((long)realm) : null;
        event.location = protocol + "://" + hostStr;
        this.chromium.getDisplay().syncExec(() -> {
            AuthenticationListener[] authenticationListenerArray = this.authenticationListeners;
            int n = this.authenticationListeners.length;
            int n2 = 0;
            while (n2 < n) {
                AuthenticationListener listener = authenticationListenerArray[n2];
                listener.authenticate(event);
                ++n2;
            }
            if (authenticationEvent.doit && authenticationEvent.user == null && authenticationEvent.password == null) {
                new AuthDialog(this.chromium.getShell()).open(event, realmStr);
            }
        });
        ChromiumLib.cefswt_auth_callback((long)callback, (String)event.user, (String)event.password, (int)(event.doit ? 1 : 0));
        return event.doit ? 1 : 0;
    }

    public int getBrowserId() {
        return this.browserId;
    }

    @Override
    public String getBrowserType() {
        return "chromium";
    }

    @Override
    public String getText() {
        this.checkBrowser();
        return this.text;
    }

    @Override
    public String getUrl() {
        if (this.browser == 0L) {
            if (this.url == null) {
                return "about:blank";
            }
            return Chromium.getPlainUrl(this.url);
        }
        long urlPtr = cef_browser_t.cefswt_get_url((long)this.browser);
        String cefurl = null;
        if (urlPtr != 0L) {
            cefurl = ChromiumLib.cefswt_cstring_to_java((long)urlPtr);
        }
        cefurl = cefurl == null ? Chromium.getPlainUrl(this.url) : Chromium.getPlainUrl(cefurl);
        return cefurl;
    }

    @Override
    public boolean isBackEnabled() {
        return this.canGoBack;
    }

    @Override
    public boolean isFocusControl() {
        return this.hasFocus;
    }

    @Override
    public boolean isForwardEnabled() {
        return this.canGoForward;
    }

    public void on_address_change(long frame, long url) {
        if (this.isDisposed() || this.locationListeners == null) {
            return;
        }
        LocationEvent event = new LocationEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.doit = true;
        event.location = Chromium.getPlainUrl(ChromiumLib.cefswt_cefstring_to_java((long)url));
        event.top = ChromiumLib.cefswt_is_main_frame((long)frame);
        if (!this.enableProgress.isDone()) {
            return;
        }
        this.chromium.getDisplay().asyncExec(() -> {
            LocationListener[] locationListenerArray = this.locationListeners;
            int n = this.locationListeners.length;
            int n2 = 0;
            while (n2 < n) {
                LocationListener listener = locationListenerArray[n2];
                listener.changed(event);
                ++n2;
            }
        });
    }

    public void on_after_created(long browser_id) {
        if (this.isDisposed() || this.visibilityWindowListeners == null) {
            return;
        }
        if (browser_id != 0L) {
            this.browser = browser_id;
            this.browserId = cef_browser_t.cefswt_get_id((long)this.browser);
            for (String hostname : this.requestHandlers.keySet()) {
                ChromiumStatic.getSchemeHandlerFactory().registerSchemeHandler(this, hostname);
            }
            if (this.isPopup == null) {
                Point size = this.getChromiumSize();
                cef_browser_t.cefswt_resized((long)this.browser, (int)size.x, (int)size.y);
            }
            if (this.isPopup != null && this.url != null) {
                Chromium.doSetUrlPost(this.browser, this.url, this.postData, this.headers);
            } else if (!"about:blank".equals(this.url)) {
                this.enableProgress.complete(Boolean.TRUE);
            }
        }
        this.created.complete(Boolean.TRUE);
        if (ChromiumStatic.browsers.get() == 1) {
            ChromiumStatic.getMessageLoop().start();
        }
        if (this.isDisposed() || this.visibilityWindowListeners == null) {
            return;
        }
        org.eclipse.swt.browser.WindowEvent event = new org.eclipse.swt.browser.WindowEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.size = new Point(0, 0);
        event.location = new Point(0, 0);
        if (this.isPopup != null) {
            event.size = this.isPopup.size;
            event.location = this.isPopup.location;
            event.addressBar = this.isPopup.addressBar;
            event.menuBar = this.isPopup.menuBar;
            event.statusBar = this.isPopup.statusBar;
            event.toolBar = this.isPopup.toolBar;
            if (event.size != null && !event.size.equals((Object)new Point(0, 0))) {
                Point size = event.size;
                this.chromium.getShell().setSize(this.chromium.getShell().computeSize(size.x, size.y));
            }
            VisibilityWindowListener[] visibilityWindowListenerArray = this.visibilityWindowListeners;
            int n = this.visibilityWindowListeners.length;
            int n2 = 0;
            while (n2 < n) {
                VisibilityWindowListener listener = visibilityWindowListenerArray[n2];
                listener.show(event);
                ++n2;
            }
        }
        try {
            Thread.sleep(75L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int on_before_browse(long browser_id2, long frame, long request) {
        if (this.isDisposed() || this.locationListeners == null) {
            return 0;
        }
        if (ChromiumLib.cefswt_is_main_frame((long)frame)) {
            LocationEvent event = new LocationEvent((Widget)this.chromium);
            event.display = this.chromium.getDisplay();
            event.widget = this.chromium;
            event.doit = true;
            event.location = Chromium.getPlainUrl(ChromiumLib.cefswt_request_to_java((long)request));
            try {
                ChromiumStatic.getMessageLoop().pause();
                LocationListener[] locationListenerArray = this.locationListeners;
                int n = this.locationListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    LocationListener listener = locationListenerArray[n2];
                    listener.changing(event);
                    ++n2;
                }
            }
            finally {
                ChromiumStatic.getMessageLoop().unpause();
            }
            if (!event.doit) {
                this.enableProgress = new CompletableFuture();
            }
            return event.doit ? 0 : 1;
        }
        return 0;
    }

    public void on_before_close(long browser_id) {
        Display display = Display.getDefault();
        if (!this.isDisposed() && this.closeWindowListeners != null) {
            org.eclipse.swt.browser.WindowEvent event = new org.eclipse.swt.browser.WindowEvent((Widget)this.chromium);
            event.display = display;
            event.widget = this.chromium;
            CloseWindowListener[] closeWindowListenerArray = this.closeWindowListeners;
            int n = this.closeWindowListeners.length;
            int n2 = 0;
            while (n2 < n) {
                CloseWindowListener listener = closeWindowListenerArray[n2];
                listener.close(event);
                ++n2;
            }
        }
        if (this.disposing == Dispose.FromClose || this.disposing == Dispose.Unload || this.disposing == Dispose.UnloadClosed || this.disposing == Dispose.WaitIfClosed) {
            this.disposing = Dispose.DoIt;
        } else if (this.disposing == Dispose.No && this.chromium != null) {
            this.disposing = Dispose.FromBrowser;
            this.chromium.dispose();
        }
        Display.getCurrent().asyncExec(() -> {
            this.clientHandler.dispose();
            this.popupClientHandler.dispose();
            this.textVisitor.dispose();
        });
        this.browser = 0L;
        this.chromium = null;
    }

    public int on_before_popup(long popupFeaturesPtr, long windowInfo, long client) {
        if (this.isDisposed()) {
            return 1;
        }
        if (this.openWindowListeners == null) {
            return 0;
        }
        WindowEvent event = new WindowEvent((Widget)this.chromium);
        cef_popup_features_t popupFeatures = new cef_popup_features_t();
        ChromiumLib.memmove((cef_popup_features_t)popupFeatures, (long)popupFeaturesPtr);
        try {
            Thread.sleep(75L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.chromium.getDisplay().syncExec(() -> {
            windowEvent.display = this.chromium.getDisplay();
            windowEvent.widget = this.chromium;
            windowEvent.required = false;
            windowEvent.addressBar = false;
            windowEvent.menuBar = false;
            windowEvent.statusBar = false;
            windowEvent.toolBar = false;
            int x = cef_popup_features_t2.xSet == 1 ? cef_popup_features_t2.x : 0;
            int y = cef_popup_features_t2.ySet == 1 ? cef_popup_features_t2.y : 0;
            windowEvent.location = cef_popup_features_t2.xSet == 1 || cef_popup_features_t2.ySet == 1 ? new Point(x, y) : null;
            int width = cef_popup_features_t2.widthSet == 1 ? cef_popup_features_t2.width : 0;
            int height = cef_popup_features_t2.heightSet == 1 ? cef_popup_features_t2.height : 0;
            windowEvent.size = cef_popup_features_t2.widthSet == 1 || cef_popup_features_t2.heightSet == 1 ? new Point(width, height) : null;
            OpenWindowListener[] openWindowListenerArray = this.openWindowListeners;
            int n = this.openWindowListeners.length;
            int n2 = 0;
            while (n2 < n) {
                OpenWindowListener listener = openWindowListenerArray[n2];
                listener.open(event);
                ++n2;
            }
            if (windowEvent.browser != null) {
                if (((Chromium)windowEvent.browser.webBrowser).instance == 0) {
                    ((Chromium)windowEvent.browser.webBrowser).createPopup(windowInfo, client, event);
                } else {
                    windowEvent.required = true;
                }
            } else if (!windowEvent.required) {
                this.instance = ++ChromiumStatic.INSTANCES;
                ChromiumLib.cefswt_set_window_info_parent((long)windowInfo, (long)client, (long)this.popupClientHandler.get(), (long)0L, (int)(windowEvent.location != null ? windowEvent.location.x : 0), (int)(windowEvent.location != null ? windowEvent.location.y : 0), (int)(windowEvent.size != null ? windowEvent.size.x : 0), (int)(windowEvent.size != null ? windowEvent.size.y : 0));
            }
        });
        if (event.browser == null && event.required) {
            return 1;
        }
        if (event.browser != null && event.required) {
            return 1;
        }
        return 0;
    }

    public int on_before_unload_dialog(long message_text, int is_reload, long callback) {
        if (this.disposing == Dispose.FromClose) {
            this.disposing = Dispose.Unload;
            String msg = ChromiumLib.cefswt_cefstring_to_java((long)message_text);
            this.openJsDialog(2, "Are you sure you want to leave this page?", msg, 0L, callback);
            this.disposing = Dispose.UnloadClosed;
            return 1;
        }
        return 0;
    }

    public void on_dialog_closed() {
        if (this.disposing == Dispose.Unload) {
            this.disposing = Dispose.UnloadClosed;
        }
    }

    public void on_got_focus() {
        if (!this.isDisposed()) {
            this.hasFocus = true;
            if (!this.isDisposed() && this.chromium.getDisplay().getFocusControl() != null) {
                this.chromium.setFocus();
            }
            this.browserFocus(true);
        }
    }

    public int on_jsdialog(long origin_url, int dialog_type, long message_text, long default_prompt_text, long callback) {
        if (this.isDisposed()) {
            return 0;
        }
        String url = ChromiumLib.cefswt_cefstring_to_java((long)origin_url);
        String title = Chromium.getPlainUrl(url);
        String msg = ChromiumLib.cefswt_cefstring_to_java((long)message_text);
        this.openJsDialog(dialog_type, title, msg, default_prompt_text, callback);
        return 1;
    }

    public void on_loading_state_change(int isLoading, int canUserGoBack, int canUserGoForward) {
        this.canGoBack = canUserGoBack == 1;
        boolean bl = this.canGoForward = canUserGoForward == 1;
        if (this.isDisposed() || this.progressListeners == null) {
            return;
        }
        if (isLoading == 0) {
            for (BrowserFunction function : this.functions.values()) {
                if (function.index == 0) continue;
                cef_browser_t.cefswt_function((long)this.browser, (String)function.name, (int)function.index);
            }
        }
        this.updateText();
        if (this.isPopup != null) {
            this.textReady.thenRun(() -> {
                boolean bl = this.enableProgress.complete(Boolean.TRUE);
            });
        } else {
            if (!this.enableProgress.isDone() && isLoading == 0) {
                this.textReady.thenRun(() -> {
                    boolean bl = this.enableProgress.complete(Boolean.TRUE);
                });
                return;
            }
            if (!this.enableProgress.isDone()) {
                return;
            }
        }
        ProgressEvent event = new ProgressEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.current = isLoading == 1 ? 1 : 100;
        event.total = 100;
        if (isLoading == 1) {
            ProgressListener[] progressListenerArray = this.progressListeners;
            int n = this.progressListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ProgressListener listener = progressListenerArray[n2];
                listener.changed(event);
                ++n2;
            }
        } else {
            this.textReady.thenRun(() -> this.chromium.getDisplay().asyncExec(() -> {
                ProgressListener[] progressListenerArray = this.progressListeners;
                int n = this.progressListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    ProgressListener listener = progressListenerArray[n2];
                    listener.completed(event);
                    ++n2;
                }
            }));
        }
    }

    public int on_process_message_received(int source, long processMessage) {
        if (source != 1 || !this.jsEnabled || this.chromium == null) {
            return 0;
        }
        FunctionSt fn = new FunctionSt();
        ChromiumLib.cefswt_function_id((long)processMessage, (FunctionSt)fn);
        int id = fn.id;
        if (id < 0) {
            return 0;
        }
        int argsSize = fn.args;
        Object[] args = new Object[argsSize];
        int i = 0;
        while (i < argsSize) {
            int arg = i;
            EvalReturned callback = (loop, type, valuePtr) -> {
                if (loop == 0) {
                    String value = ChromiumLib.cefswt_cstring_to_java((long)valuePtr);
                    objectArray[n] = this.mapType(type, value);
                }
            };
            Callback callback_cb = new Callback((Object)callback, "invoke", Void.TYPE, new Type[]{Integer.TYPE, Integer.TYPE, Long.TYPE});
            ChromiumLib.cefswt_function_arg((long)processMessage, (int)i, (long)Chromium.checkGetAddress(callback_cb));
            Chromium.disposeCallback(callback_cb);
            ++i;
        }
        Object ret = ((BrowserFunction)this.functions.get(id)).function(args);
        Object[] returnPair = this.convertType(ret);
        CEFFactory.ReturnType returnType = (CEFFactory.ReturnType)((Object)returnPair[0]);
        String returnStr = (String)returnPair[1];
        ChromiumLib.cefswt_function_return((long)this.browser, (int)id, (int)fn.port, (int)returnType.intValue(), (String)returnStr);
        return 1;
    }

    public int on_set_focus() {
        if (this.ignoreFirstFocus) {
            this.ignoreFirstFocus = false;
            return 1;
        }
        return 0;
    }

    public void on_status_message(long status) {
        if (this.isDisposed() || this.statusTextListeners == null) {
            return;
        }
        String str = status == 0L ? "" : ChromiumLib.cefswt_cefstring_to_java((long)status);
        StatusTextEvent event = new StatusTextEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.text = str;
        StatusTextListener[] statusTextListenerArray = this.statusTextListeners;
        int n = this.statusTextListeners.length;
        int n2 = 0;
        while (n2 < n) {
            StatusTextListener listener = statusTextListenerArray[n2];
            listener.changed(event);
            ++n2;
        }
    }

    public void on_take_focus(int next) {
        int indexOf;
        this.hasFocus = false;
        Control[] tabOrder = this.chromium.getParent().getTabList();
        if (tabOrder.length == 0) {
            tabOrder = this.chromium.getParent().getChildren();
        }
        if ((indexOf = Arrays.asList(tabOrder).indexOf((Object)this.chromium)) != -1) {
            int newIndex;
            int n = newIndex = next == 1 ? indexOf + 1 : indexOf - 1;
            if (newIndex > 0 && newIndex < tabOrder.length && !tabOrder[newIndex].isDisposed()) {
                tabOrder[newIndex].setFocus();
                return;
            }
        }
        if (!this.isDisposed() && !this.chromium.getParent().isDisposed()) {
            this.chromium.getParent().setFocus();
        }
    }

    public void on_title_change(long title) {
        if (this.isDisposed() || this.titleListeners == null) {
            return;
        }
        String full_str = ChromiumLib.cefswt_cefstring_to_java((long)title);
        String str = Chromium.getPlainUrl(full_str);
        TitleEvent event = new TitleEvent((Widget)this.chromium);
        event.display = this.chromium.getDisplay();
        event.widget = this.chromium;
        event.title = str;
        TitleListener[] titleListenerArray = this.titleListeners;
        int n = this.titleListeners.length;
        int n2 = 0;
        while (n2 < n) {
            TitleListener listener = titleListenerArray[n2];
            listener.changed(event);
            ++n2;
        }
    }

    public ResourceHandler onRequestCustomHandler(String name) {
        if (!this.requestHandlers.containsKey(name)) {
            return null;
        }
        RequestHandler requestHandler = (RequestHandler)this.requestHandlers.get(name);
        return new ResourceHandler(requestHandler);
    }

    @Override
    public void refresh() {
        this.jsEnabled = this.jsEnabledOnNextPage;
        if (this.browser != 0L) {
            cef_browser_t.cefswt_reload((long)this.browser);
        }
    }

    @Override
    public void registerRequestHandler(String hostname, RequestHandler handler) {
        this.requestHandlers.put(hostname, handler);
    }

    public int run_context_menu(long callback) {
        if (this.chromium.getMenu() != null) {
            this.chromium.getMenu().setVisible(true);
            ChromiumLib.cefswt_context_menu_cancel((long)callback);
            return 1;
        }
        return 0;
    }

    @Override
    public void setBrowser(Browser browser) {
        this.chromium = browser;
    }

    @Override
    public boolean setText(String html, boolean trusted) {
        if (html.contains("file:/")) {
            try {
                Path tmp = Files.createTempFile(SET_TEXT_URL, ".html", new FileAttribute[0]);
                Files.write(tmp, html.getBytes(), new OpenOption[0]);
                tmp.toFile().deleteOnExit();
                return this.setUrl(tmp.toUri().toString(), null, null);
            }
            catch (IOException tmp) {
                // empty catch block
            }
        }
        String texturl = DATA_TEXT_URL + Base64.getEncoder().encodeToString(html.getBytes());
        return this.setUrl(texturl, null, null);
    }

    @Override
    public boolean setUrl(String url, String postData, String[] headers) {
        this.url = url;
        this.postData = postData;
        this.headers = headers;
        this.jsEnabled = this.jsEnabledOnNextPage;
        if (!this.isDisposed() && this.browser != 0L) {
            this.doSetUrl(url, postData, headers);
        }
        return true;
    }

    @Override
    public void stop() {
        if (this.browser != 0L) {
            cef_browser_t.cefswt_stop((long)this.browser);
        }
    }

    private synchronized void checkBrowser() {
        if (this.browser == 0L) {
            SWT.error((int)24);
        }
    }

    private Object[] convertType(Object ret) {
        CEFFactory.ReturnType returnType = CEFFactory.ReturnType.Error;
        Object returnStr = "";
        if (ret == null) {
            returnType = CEFFactory.ReturnType.Null;
            returnStr = "null";
        } else if (Boolean.class.isInstance(ret)) {
            returnType = CEFFactory.ReturnType.Bool;
            returnStr = Boolean.TRUE.equals(ret) ? "1" : "0";
        } else if (Number.class.isInstance(ret)) {
            returnType = CEFFactory.ReturnType.Double;
            returnStr = NumberFormat.getInstance(Locale.US).format(ret);
        } else if (String.class.isInstance(ret)) {
            returnType = CEFFactory.ReturnType.Str;
            returnStr = ret.toString();
        } else if (ret.getClass().isArray()) {
            returnType = CEFFactory.ReturnType.Array;
            StringBuilder buffer = new StringBuilder();
            buffer.append("\"");
            int i = 0;
            while (i < Array.getLength(ret)) {
                if (i > 0) {
                    buffer.append(";");
                }
                Object[] arrayElem = this.convertType(Array.get(ret, i));
                buffer.append("'");
                buffer.append(((CEFFactory.ReturnType)((Object)arrayElem[0])).intValue());
                buffer.append(",");
                buffer.append((String)arrayElem[1]);
                buffer.append("'");
                ++i;
            }
            buffer.append("\"");
            returnStr = buffer.toString();
        } else {
            returnStr = "Unsupported return type " + ret.getClass().getName();
        }
        return new Object[]{returnType, returnStr};
    }

    private void createBrowser() {
        if (this.url == null) {
            this.url = "about:blank";
        }
        this.prepareBrowser();
        Display display = this.chromium.getDisplay();
        Color bg = this.chromium.getBackground();
        Color bgColor = bg != null ? bg : display.getSystemColor(22);
        int cefBgColor = Chromium.cefColor(bgColor.getAlpha(), bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
        Point size = this.getChromiumSize();
        this.instance = ++ChromiumStatic.INSTANCES;
        ChromiumStatic.instances.put(this.instance, this);
        ChromiumLib.cefswt_create_browser((long)this.hwnd, (String)this.url, (long)this.clientHandler.get(), (int)size.x, (int)size.y, (int)(this.jsEnabledOnNextPage ? 1 : 0), (int)cefBgColor);
    }

    private void createPopup(long windowInfo, long client, WindowEvent event) {
        if (this.paintListener != null) {
            this.chromium.removePaintListener(this.paintListener);
            this.paintListener = null;
        } else {
            ChromiumStatic.instances.remove(this.instance);
        }
        this.instance = ++ChromiumStatic.INSTANCES;
        ChromiumStatic.instances.put(this.instance, this);
        this.isPopup = event;
        this.prepareBrowser();
        long popupHandle = this.hwnd;
        Point size = new Point(0, 0);
        ChromiumLib.cefswt_set_window_info_parent((long)windowInfo, (long)client, (long)this.clientHandler.get(), (long)popupHandle, (int)0, (int)0, (int)size.x, (int)size.y);
    }

    private CompletableFuture<Void> doSetUrl(String url, String postData, String[] headers) {
        return this.enableProgress.thenRun(() -> Chromium.doSetUrlPost(this.browser, url, postData, headers));
    }

    private Point getChromiumSize() {
        return DPIUtil.autoScaleUp((Point)this.chromium.getSize());
    }

    private Object mapType(int type, String value) throws SWTException {
        if (type == CEFFactory.ReturnType.Error.intValue()) {
            if ("51".equals(value)) {
                throw new SWTException(51);
            }
            throw new SWTException(50, value);
        }
        if (type == CEFFactory.ReturnType.Null.intValue()) {
            return null;
        }
        if (type == CEFFactory.ReturnType.Bool.intValue()) {
            return "1".equals(value) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (type == CEFFactory.ReturnType.Double.intValue()) {
            return Double.valueOf(value);
        }
        if (type == CEFFactory.ReturnType.Array.intValue()) {
            String value_unquoted = value.substring(1, value.length() - 1);
            String[] elements = value_unquoted.split(";(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
            Object[] array = new Object[elements.length];
            int i = 0;
            while (i < array.length) {
                Object elemValue;
                String elemUnquoted = elements[i].substring(1, elements[i].length() - 1);
                String[] parts = elemUnquoted.split(",(?=(?:[^']*'[^']*')*[^']*$)", 2);
                CEFFactory.ReturnType elemType = CEFFactory.ReturnType.from(parts[0]);
                array[i] = elemValue = this.mapType(elemType.intValue(), parts[1]);
                ++i;
            }
            return array;
        }
        return value;
    }

    private void openJsDialog(int dialog_type, String title, String msg, long default_prompt_text, long callback) {
        int style = 16;
        switch (dialog_type) {
            case 0: {
                style = 2;
                break;
            }
            case 1: {
                style = 8;
                break;
            }
            case 2: {
                style = 196;
                break;
            }
            default: {
                style = 4;
            }
        }
        Consumer<Integer> close = open -> {
            int r = open == 32 || open == 64 ? 1 : 0;
            ChromiumLib.cefswt_dialog_close((long)callback, (int)r, (long)default_prompt_text);
            this.chromium.getShell().forceActive();
        };
        if (!"test".equals(System.getProperty("swt.chromium.dialogs", ""))) {
            MessageBox box = new MessageBox(this.chromium.getShell(), style);
            box.setText(title);
            box.setMessage(msg);
            int open2 = box.open();
            close.accept(open2);
        } else {
            CompletableFuture f = (CompletableFuture)this.chromium.getData("swt.chromium.dialogs");
            if (f != null) {
                f.thenAccept(close);
                this.chromium.setData("swt.chromium.dialogs", null);
                while (!f.isDone()) {
                    if (this.chromium.getDisplay().readAndDispatch()) continue;
                    this.chromium.getDisplay().sleep();
                }
            }
        }
    }

    private void prepareBrowser() {
        this.hwnd = Chromium.getHandle(this.chromium);
        this.chromium.addDisposeListener(e -> this.dispose());
        this.focusListener = new CEFFocusListener();
        this.chromium.addFocusListener(this.focusListener);
        this.chromium.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!Chromium.this.isDisposed() && Chromium.this.browser != 0L) {
                    Point size = Chromium.this.getChromiumSize();
                    cef_browser_t.cefswt_resized((long)Chromium.this.browser, (int)size.x, (int)size.y);
                }
            }
        });
    }

    private void updateText() {
        if (this.browser != 0L && !this.isDisposed() && this.disposing == Dispose.No) {
            cef_browser_t.cefswt_get_text((long)this.browser, (long)this.textVisitor.get());
        }
    }

    private void waitForClose(Display display) {
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(() -> {
            if (this.browser != 0L) {
                this.waitForClose(display);
            }
        });
    }

    protected void browserFocus(boolean set) {
        if (!this.isDisposed() && this.browser != 0L) {
            long parent;
            long l = parent = Display.getDefault().getActiveShell() == null ? 0L : Chromium.getHandle(this.chromium.getParent());
            if (this.chromium.getDisplay().getActiveShell() != this.chromium.getShell()) {
                return;
            }
            cef_browser_t.cefswt_set_focus((long)this.browser, (boolean)set, (long)parent);
        }
    }

    boolean isDisposed() {
        return this.chromium == null || this.chromium.isDisposed();
    }

    public int on_console_message(long id, int severity, long message, long source, int line) {
        if (this.consoleListener != null) {
            String msg = message == 0L ? "" : ChromiumLib.cefswt_cefstring_to_java((long)message);
            String src = source == 0L ? "" : ChromiumLib.cefswt_cefstring_to_java((long)source);
            this.consoleListener.onConsoleMessage(severity, msg, src, line);
            return 1;
        }
        return 0;
    }

    final class CEFFocusListener
    implements FocusListener {
        private boolean enabled = true;

        CEFFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            if (!this.enabled) {
                return;
            }
            Chromium.this.browserFocus(true);
        }

        public void focusLost(FocusEvent e) {
            if (!this.enabled) {
                return;
            }
            this.enabled = false;
            Chromium.this.browserFocus(false);
            this.enabled = true;
        }
    }

    static enum Dispose {
        DoIt,
        FromBrowser,
        FromClose,
        FromDispose,
        No,
        Unload,
        UnloadClosed,
        WaitIfClosed;

    }

    public static interface EvalReturned {
        public void invoke(int var1, int var2, long var3);
    }
}

