/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow.combobox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.nebula.widgets.nattable.data.convert.ConversionFailedException;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterNatCombo;
import org.eclipse.nebula.widgets.nattable.filterrow.combobox.FilterRowComboBoxDataProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.nebula.widgets.nattable.widget.NatCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterRowComboBoxCellEditor
extends ComboBoxCellEditor {
    private static final Logger LOG = LoggerFactory.getLogger(FilterRowComboBoxCellEditor.class);
    private Object currentCanonicalValue = null;
    private boolean applyFilterOnDropdownFilter = false;
    private boolean closeOnEnterInDropdownFilter = false;
    private List<?> notVisibleSelected;

    public FilterRowComboBoxCellEditor(IComboBoxDataProvider dataProvider) {
        this(dataProvider, 5);
    }

    public FilterRowComboBoxCellEditor(IComboBoxDataProvider dataProvider, int maxVisibleItems) {
        super(dataProvider, maxVisibleItems);
        this.multiselect = true;
        this.useCheckbox = true;
    }

    @Override
    public NatCombo createEditorControl(Composite parent) {
        FilterNatCombo combo;
        int style = 42;
        FilterNatCombo filterNatCombo = combo = this.iconImage == null ? new FilterNatCombo(parent, this.cellStyle, this.maxVisibleItems, style, this.showDropdownFilter) : new FilterNatCombo(parent, this.cellStyle, this.maxVisibleItems, style, this.iconImage, this.showDropdownFilter);
        if (this.freeEdit) {
            combo.setCursor(Display.getDefault().getSystemCursor(19));
        } else {
            combo.setCursor(Display.getDefault().getSystemCursor(0));
        }
        combo.setMultiselectValueSeparator(this.multiselectValueSeparator);
        combo.setMultiselectTextBracket(this.multiselectTextPrefix, this.multiselectTextSuffix);
        this.addNatComboListener(combo);
        combo.addCheckStateListener(event -> {
            if (event.getChecked()) {
                this.setEditorValue(new String[]{"SELECT_ALL"});
            }
            this.commit(SelectionLayer.MoveDirectionEnum.NONE, !this.multiselect && this.editMode == EditModeEnum.INLINE);
        });
        if (this.applyFilterOnDropdownFilter) {
            combo.setFilterModifyAction(() -> this.commit(SelectionLayer.MoveDirectionEnum.NONE, !this.multiselect && this.editMode == EditModeEnum.INLINE));
        }
        if (this.closeOnEnterInDropdownFilter) {
            combo.setDropdownFilterKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.keyCode == 13 || event.keyCode == 0x1000050 || event.keyCode == 27) {
                        FilterRowComboBoxCellEditor.this.close();
                    }
                }
            });
        }
        return combo;
    }

    @Override
    public void setCanonicalValue(Object canonicalValue) {
        this.currentCanonicalValue = canonicalValue;
        if (this.getComboBoxDataProvider() != null && this.getComboBoxDataProvider() instanceof FilterRowComboBoxDataProvider && ((FilterRowComboBoxDataProvider)this.getComboBoxDataProvider()).getFilterCollection() != null) {
            List<?> allValues = ((FilterRowComboBoxDataProvider)this.getComboBoxDataProvider()).getAllValues(this.getColumnIndex());
            List<?> visibleValues = this.getComboBoxDataProvider().getValues(this.getColumnIndex(), this.getRowIndex());
            ArrayList diffValues = new ArrayList(allValues);
            diffValues.removeAll(visibleValues);
            if (canonicalValue instanceof Collection) {
                Collection cValues = (Collection)canonicalValue;
                Iterator it = diffValues.iterator();
                while (it.hasNext()) {
                    Object object = it.next();
                    if (cValues.contains(object)) continue;
                    it.remove();
                }
            }
            if ("SELECT_ALL".equals(canonicalValue)) {
                this.currentCanonicalValue = allValues;
            }
            this.notVisibleSelected = diffValues.stream().map(v -> this.handleConversion(v, this.conversionEditErrorHandler)).collect(Collectors.toList());
        }
        super.setCanonicalValue(canonicalValue);
    }

    @Override
    public Object getCanonicalValue() {
        Object canonicalValue = super.getCanonicalValue();
        if (canonicalValue instanceof Collection && this.notVisibleSelected != null) {
            ((Collection)canonicalValue).addAll(this.notVisibleSelected);
        }
        return canonicalValue;
    }

    @Override
    public boolean commit(SelectionLayer.MoveDirectionEnum direction, boolean closeAfterCommit) {
        boolean dropdownFilterActive = false;
        NatCombo editorControl = this.getEditorControl();
        if (editorControl != null && editorControl instanceof FilterNatCombo && ((FilterNatCombo)editorControl).isFilterActive()) {
            dropdownFilterActive = true;
        }
        if (dropdownFilterActive) {
            if (closeAfterCommit) {
                this.close();
            }
            return true;
        }
        if (!this.isClosed()) {
            block11: {
                Object canonicalValue = this.getCanonicalValue();
                if (!(canonicalValue != null && this.currentCanonicalValue == null || canonicalValue == null && this.currentCanonicalValue != null) && (canonicalValue == null || this.currentCanonicalValue == null || canonicalValue.equals(this.currentCanonicalValue))) break block11;
                if (super.commit(direction, closeAfterCommit)) {
                    this.currentCanonicalValue = canonicalValue;
                    if (!dropdownFilterActive && ((FilterNatCombo)editorControl).initialSelection != null) {
                        ((FilterNatCombo)editorControl).initialSelection = editorControl.getSelection();
                    }
                    return true;
                }
            }
            try {
                if (closeAfterCommit) {
                    this.close();
                }
                return true;
            }
            catch (ConversionFailedException canonicalValue) {
            }
            catch (Exception e) {
                LOG.error("Error on updating cell value: {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
        }
        return false;
    }

    public void configureDropdownFilter(boolean applyFilter, boolean closeOnEnter) {
        this.setShowDropdownFilter(true);
        this.applyFilterOnDropdownFilter = applyFilter;
        this.closeOnEnterInDropdownFilter = closeOnEnter;
    }

    protected boolean isApplyFilterOnDropdownFilter() {
        return this.applyFilterOnDropdownFilter;
    }

    protected boolean isCloseOnEnterInDropdownFilter() {
        return this.closeOnEnterInDropdownFilter;
    }
}

