/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.overview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.feature.table.messages.Messages;
import org.eclipse.set.feature.table.overview.TableErrorTransformationService;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.utils.events.TableSelectRowByGuidEvent;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEvents;
import org.eclipse.set.utils.table.TableError;
import org.eclipse.set.utils.table.sorting.AbstractSortByColumnTables;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TableErrorTableView
extends AbstractSortByColumnTables {
    private static final String TABLE_PART_ID_PREFIX = "org.eclipse.set.feature.table.";
    private final Messages messages;
    private NatTable natTable;
    private Collection<TableError> tableErrors = new ArrayList<TableError>();
    private final IEventBroker broker;
    private final ToolboxPartService toolboxPartService;

    public TableErrorTableView(Messages messages, IEventBroker broker, ToolboxPartService toolboxPartService) {
        this.messages = messages;
        this.broker = broker;
        this.toolboxPartService = toolboxPartService;
    }

    public Control create(Composite parent) {
        Table table = this.getTable();
        this.natTable = this.createTable(parent, table, null);
        this.natTable.getUiBindingRegistry().registerFirstDoubleClickBinding((IMouseEventMatcher)MouseEventMatcher.bodyLeftClick((int)0), (natTable2, event) -> {
            Collection selectedCells = this.bodyLayerStack.getSelectionLayer().getSelectedCells();
            if (selectedCells.isEmpty()) {
                return;
            }
            int row = ((ILayerCell)selectedCells.iterator().next()).getRowPosition();
            int originalRow = this.bodyDataProvider.getOriginalRowIndex(row);
            Optional<TableError> rowElement = this.tableErrors.stream().skip(originalRow).findFirst();
            if (rowElement.isPresent()) {
                TableError element = rowElement.get();
                String guid = element.getLeadingObject();
                String shortCut = element.getSource().toLowerCase();
                this.toolboxPartService.showPart(TABLE_PART_ID_PREFIX + shortCut);
                ToolboxEvents.send((IEventBroker)this.broker, (ToolboxEvent)new TableSelectRowByGuidEvent(guid));
            }
        });
        return this.natTable;
    }

    public void updateView(Collection<TableError> errors) {
        this.tableErrors = errors;
        if (this.natTable != null) {
            this.bodyDataProvider.refresh(this.getTable());
            this.natTable.refresh();
        }
    }

    private Table getTable() {
        TableErrorTransformationService service = new TableErrorTransformationService(this.messages);
        return service.transform(this.tableErrors);
    }
}

