/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.abstracttableview;

import com.google.common.base.Function;
import java.util.Arrays;
import org.eclipse.set.basis.tables.Tables;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;

public class Headings {
    private static float defaultHeight;

    public static float getDefaultHeight() {
        return defaultHeight;
    }

    public static String getTreeString(ColumnDescriptor heading) {
        return Headings.getTreeString(heading, 0);
    }

    public static String getWidthTestCsv(ColumnDescriptor heading, Function<Float, Integer> toPixel) {
        int columns = ColumnDescriptorExtensions.getColumns((ColumnDescriptor)heading).length;
        StringBuilder result = new StringBuilder((columns + 1) * 12);
        result.append("Column;WidthExpected;WidthActual\n");
        int i = 0;
        while (i < columns) {
            result.append(Integer.toString(i + 1)).append(";").append(toPixel.apply((Object)ColumnDescriptorExtensions.getColumnWidth((ColumnDescriptor)heading, (int)i))).append(";0\n");
            ++i;
        }
        return result.toString();
    }

    public static void setDefaultHeight(float defaultHeight) {
        Headings.defaultHeight = defaultHeight;
    }

    private static String getTreeString(ColumnDescriptor heading, int level) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < level) {
            result.append("  ");
            ++i;
        }
        int columnIndex = Arrays.asList(ColumnDescriptorExtensions.getColumns((ColumnDescriptor)heading)).indexOf(heading);
        if (columnIndex >= 0) {
            result.append(String.format("Column %d (id=%s greyed=%b width=%.2f cm): ", columnIndex, Tables.getColumnIdentifier((int)columnIndex), heading.isGreyed(), ColumnDescriptorExtensions.getColumnWidth((ColumnDescriptor)heading, (int)columnIndex)));
        }
        if (ColumnDescriptorExtensions.isGroup((ColumnDescriptor)heading)) {
            result.append("Group: ");
        }
        if (ColumnDescriptorExtensions.isGroupGroup((ColumnDescriptor)heading)) {
            result.append("Group group: ");
        }
        if (ColumnDescriptorExtensions.isGroupGroupGroup((ColumnDescriptor)heading)) {
            result.append("Group group group: ");
        }
        result.append(String.format("\"%s\"", heading.getLabel()));
        result.append("\n");
        for (ColumnDescriptor child : heading.getChildren()) {
            result.append(Headings.getTreeString(child, level + 1));
        }
        return result.toString();
    }
}

