/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.model.handler;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.IServiceHandler;
import org.eclipse.sequoyah.device.framework.status.IStatusTransition;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceHandler
implements IServiceHandler {
    private IServiceHandler parent;
    private IService service;

    @Override
    public IServiceHandler getParent() {
        return this.parent;
    }

    @Override
    public void run(IInstance iInstance) throws SequoyahException {
        this.run(iInstance, null);
    }

    public void run(IInstance iInstance, Map<Object, Object> map) throws SequoyahException {
        if (!this.verifyStatus(iInstance)) {
            throw new SequoyahException();
        }
        this.createJob(iInstance, map);
    }

    public IStatus run(IInstance iInstance, Map<Object, Object> map, IProgressMonitor iProgressMonitor) throws SequoyahException {
        if (!this.verifyStatus(iInstance)) {
            throw new SequoyahException();
        }
        String string = this.service != null ? this.service.getName() : "";
        return this.doRun(iInstance, map, string, iProgressMonitor);
    }

    private void createJob(final IInstance iInstance, final Map<Object, Object> map) {
        final String string = this.service != null ? String.valueOf(this.service.getName()) + " : " + iInstance.getName() : "";
        final Job job = new Job(string){

            public IStatus run(IProgressMonitor iProgressMonitor) {
                IStatus iStatus = null;
                try {
                    iStatus = ServiceHandler.this.doRun(iInstance, map, string, iProgressMonitor);
                }
                catch (SequoyahException sequoyahException) {
                    sequoyahException.printStackTrace();
                }
                return iStatus;
            }
        };
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getProgressService().showInDialog(null, job);
            }
        });
        job.schedule();
    }

    private IStatus doRun(IInstance iInstance, Map<Object, Object> map, String string, IProgressMonitor iProgressMonitor) throws SequoyahException {
        return iInstance.getStateMachineHandler().runService(this, iInstance, map, string, iProgressMonitor);
    }

    @Override
    public void setService(IService iService) {
        this.service = iService;
    }

    @Override
    public IService getService() {
        return this.service;
    }

    public abstract IStatus runService(IInstance var1, Map<Object, Object> var2, IProgressMonitor var3);

    public abstract IStatus updatingService(IInstance var1, IProgressMonitor var2);

    @Override
    public abstract IServiceHandler newInstance();

    @Override
    public void updatingService(IInstance iInstance) {
    }

    public boolean verifyStatus(IInstance iInstance) {
        IStatusTransition iStatusTransition = this.getService().getStatusTransitions(iInstance.getDeviceTypeId(), iInstance.getStatus());
        return iStatusTransition != null;
    }

    @Override
    public void setParent(IServiceHandler iServiceHandler) {
        this.parent = iServiceHandler;
    }

    @Override
    public Object clone() {
        IServiceHandler iServiceHandler = this.newInstance();
        iServiceHandler.setParent(this.parent);
        iServiceHandler.setService(this.service);
        return iServiceHandler;
    }

    @Override
    public IStatus singleInit(List<IInstance> list) {
        return Status.OK_STATUS;
    }
}

