/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.stringeditor.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.localization.stringeditor.datatype.CellInfo;
import org.eclipse.sequoyah.localization.stringeditor.datatype.ColumnInfo;
import org.eclipse.sequoyah.localization.stringeditor.datatype.IModelChangedListener;
import org.eclipse.sequoyah.localization.stringeditor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.stringeditor.providers.ICellValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEditorViewerModel {
    private final List<ColumnInfo> columns;
    private final Map<String, ColumnInfo> columnsMap;
    private final Map<String, RowInfo> rowsMap;
    private final ICellValidator validator;
    private final List<IModelChangedListener> listeners;

    public StringEditorViewerModel(List<ColumnInfo> list, ICellValidator iCellValidator) {
        this.columns = list;
        this.columnsMap = new HashMap<String, ColumnInfo>();
        this.rowsMap = new TreeMap<String, RowInfo>();
        this.listeners = new ArrayList<IModelChangedListener>();
        this.validator = iCellValidator;
        this.initMaps();
        this.doInitialValidation();
    }

    private void doInitialValidation() {
        for (RowInfo rowInfo : this.rowsMap.values()) {
            this.validateRow(rowInfo.getKey());
        }
    }

    private void initMaps() {
        for (ColumnInfo columnInfo : this.columns) {
            this.columnsMap.put(columnInfo.getId(), columnInfo);
            for (String string : columnInfo.getCells().keySet()) {
                if (this.rowsMap.get(string) == null) {
                    this.rowsMap.put(string, new RowInfo(string, false, null));
                }
                RowInfo rowInfo = this.rowsMap.get(string);
                rowInfo.addCell(columnInfo.getId(), columnInfo.getCells().get(string));
            }
        }
        this.notifyListeners();
    }

    public RowInfo getRow(String string) {
        return this.rowsMap.get(string);
    }

    public ColumnInfo getColumn(String string) {
        return this.columnsMap.get(string);
    }

    public Map<String, RowInfo> getRows() {
        return this.rowsMap;
    }

    public List<ColumnInfo> getColumns() {
        return this.columns;
    }

    public void addColumn(ColumnInfo columnInfo) {
        this.columns.add(columnInfo);
        this.columnsMap.put(columnInfo.getId(), columnInfo);
        Map<String, CellInfo> map = columnInfo.getCells();
        for (String string : map.keySet()) {
            RowInfo rowInfo = this.rowsMap.get(string);
            if (rowInfo == null) {
                rowInfo = new RowInfo(string, false, null);
                this.rowsMap.put(string, rowInfo);
            }
            rowInfo.addCell(columnInfo.getId(), columnInfo.getCells().get(string));
            this.validateRow(rowInfo);
        }
        this.notifyListeners();
    }

    public void addRow(RowInfo rowInfo) {
        Map<String, CellInfo> map = rowInfo.getCells();
        this.rowsMap.put(rowInfo.getKey(), rowInfo);
        for (String string : map.keySet()) {
            ColumnInfo columnInfo = this.columnsMap.get(string);
            if (columnInfo == null) {
                columnInfo = new ColumnInfo(string, string, null, true);
                this.columnsMap.put(string, columnInfo);
                this.columns.add(columnInfo);
            }
            columnInfo.addCell(rowInfo.getKey(), map.get(string));
        }
        this.validateRow(rowInfo);
        this.notifyListeners();
    }

    public void addCell(CellInfo cellInfo, String string, String string2) {
        this.columnsMap.get(string2).addCell(string, cellInfo);
        this.rowsMap.get(string).addCell(string2, cellInfo);
        this.validateRow(string);
        this.notifyListeners();
    }

    public void removeCell(String string, String string2) {
        this.rowsMap.get(string).removeCell(string2);
        this.columnsMap.get(string2).removeCell(string);
        this.notifyListeners();
    }

    public void removeColumn(String string) {
        this.columnsMap.remove(string);
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>(this.columns);
        for (ColumnInfo object2 : arrayList) {
            if (!object2.getId().equals(string)) continue;
            this.columns.remove(object2);
        }
        HashMap<String, RowInfo> hashMap = new HashMap<String, RowInfo>(this.rowsMap);
        for (RowInfo rowInfo : hashMap.values()) {
            rowInfo.removeCell(string);
            if (!this.isEmptyRow(rowInfo)) continue;
            this.removeRow(rowInfo.getKey());
        }
        this.notifyListeners();
    }

    private boolean isEmptyRow(RowInfo rowInfo) {
        return rowInfo.getCells().size() == 0;
    }

    public void removeRow(String string) {
        this.rowsMap.remove(string);
        for (ColumnInfo columnInfo : this.columnsMap.values()) {
            columnInfo.removeCell(string);
        }
        this.notifyListeners();
    }

    public void addListener(IModelChangedListener iModelChangedListener) {
        this.listeners.add(iModelChangedListener);
    }

    public void removeListener(IModelChangedListener iModelChangedListener) {
        this.listeners.remove(iModelChangedListener);
    }

    private void notifyListeners() {
        for (IModelChangedListener iModelChangedListener : this.listeners) {
            iModelChangedListener.modelChanged(this);
        }
    }

    public List<RowInfo> save() {
        ArrayList<RowInfo> arrayList = new ArrayList<RowInfo>();
        for (RowInfo rowInfo : this.rowsMap.values()) {
            for (CellInfo cellInfo : rowInfo.getCells().values()) {
                if (cellInfo == null || !cellInfo.isDirty()) continue;
                cellInfo.setDirty(false);
                arrayList.add(rowInfo);
            }
        }
        return arrayList;
    }

    public List<ColumnInfo> getColumnsChanged() {
        HashSet<ColumnInfo> hashSet = new HashSet<ColumnInfo>();
        for (RowInfo rowInfo : this.rowsMap.values()) {
            for (Map.Entry<String, CellInfo> entry : rowInfo.getCells().entrySet()) {
                CellInfo cellInfo = entry.getValue();
                if (cellInfo == null || !cellInfo.isDirty()) continue;
                hashSet.add(this.columnsMap.get(entry.getKey()));
            }
        }
        return new ArrayList<ColumnInfo>(hashSet);
    }

    public void validateRow(String string) {
        RowInfo rowInfo = this.rowsMap.get(string);
        this.validateRow(rowInfo);
    }

    public void validateRow(RowInfo rowInfo) {
        rowInfo.cleanStatus();
        for (ColumnInfo columnInfo : this.columns) {
            CellInfo cellInfo = rowInfo.getCells().get(columnInfo.getId());
            IStatus iStatus = this.validator.isCellValid(columnInfo.getId(), rowInfo.getKey(), cellInfo != null ? cellInfo.getValue() : null);
            if (iStatus.isOK()) continue;
            rowInfo.addStatus(iStatus);
        }
    }

    public IStatus getStatus() {
        IStatus iStatus = null;
        for (RowInfo rowInfo : this.rowsMap.values()) {
            if (rowInfo.getStatus().isOK()) continue;
            if (iStatus == null) {
                iStatus = new MultiStatus("org.eclipse.sequoyah.localization.stringeditor", 0, null, null);
            }
            iStatus.merge((IStatus)rowInfo.getStatus());
        }
        return iStatus != null ? iStatus : Status.OK_STATUS;
    }
}

