/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.network;

import java.io.DataInputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.eclipse.tml.vncviewer.network.IProtoClient;

public abstract class Protocol
implements IProtoClient {
    protected Socket socket;
    protected DataInputStream in = null;
    protected OutputStream out = null;
    protected boolean paintEnabled = false;
    protected String host;
    protected int port;
    protected String password;

    protected void openConnection(String host, int port, String password) throws Exception {
        this.host = host;
        this.port = port;
        this.password = password;
        this.socket = new Socket(host, port);
        this.socket.setReceiveBufferSize(65536);
        this.in = new DataInputStream(this.socket.getInputStream());
        this.out = this.socket.getOutputStream();
    }

    protected void openConnection(String host, int port, int timeout) throws Exception {
        InetSocketAddress socketAdress = new InetSocketAddress(host, port);
        this.socket = new Socket();
        this.socket.connect(socketAdress, timeout);
        this.in = new DataInputStream(this.socket.getInputStream());
        this.out = this.socket.getOutputStream();
    }

    protected void closeConnection() throws Exception {
        this.out.close();
        this.in.close();
        this.socket.close();
    }

    public boolean isConnected() {
        boolean isConnected = false;
        if (this.socket != null && this.socket.isConnected() && !this.socket.isClosed()) {
            isConnected = true;
        }
        return isConnected;
    }

    public boolean isPaintEnabled() {
        return this.paintEnabled;
    }

    public void setPaintEnabled(boolean enabled) {
        this.paintEnabled = enabled;
    }
}

