/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.lib.internal.engine;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class NioOutputStream
extends OutputStream {
    private static final int BUFFER_SIZE = 102400;
    private SocketChannel channel;
    private ByteBuffer buffer;

    NioOutputStream(SocketChannel channel) {
        this.channel = channel;
        this.buffer = ByteBuffer.allocate(102400);
    }

    public void close() throws IOException {
        if (this.channel.isOpen()) {
            this.flush();
            this.channel.close();
        }
    }

    public void flush() throws IOException {
        this.buffer.flip();
        this.channel.write(this.buffer);
        this.buffer.clear();
    }

    public void write(int b) throws IOException {
        if (this.buffer.remaining() < 4) {
            this.flush();
        }
        this.buffer.put((byte)(b & 0xFF));
        this.flush();
    }

    public void write(byte[] b) throws IOException {
        if (this.buffer.remaining() < b.length) {
            this.flush();
        }
        this.buffer.put(b);
        this.flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.buffer.remaining() < len) {
            this.flush();
        }
        this.buffer.put(b, off, len);
        this.flush();
    }
}

