/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.browser.browserkit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.internal.browser.browserkit.BrowserOperationHandler;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.IBrowserAdapter;
import org.eclipse.swt.internal.widgets.WidgetRemoteAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public final class BrowserLCA
extends WidgetLCA<Browser> {
    public static final BrowserLCA INSTANCE = new BrowserLCA();
    private static final String TYPE = "rwt.widgets.Browser";
    private static final String[] ALLOWED_STYLES = new String[]{"BORDER"};
    static final String BLANK_HTML = "<html><script></script><body style=\"background-color: transparent;\"></body></html>";
    public static final String EVENT_PROGRESS = "Progress";
    private static final String PARAM_PROGRESS_LISTENER = "Progress";
    private static final String PARAM_SCRIPT = "script";
    private static final String METHOD_EVALUATE = "evaluate";
    private static final String PARAM_FUNCTIONS = "functions";
    private static final String METHOD_CREATE_FUNCTIONS = "createFunctions";
    private static final String METHOD_DESTROY_FUNCTIONS = "destroyFunctions";
    private static final String PARAM_FUNCTION_RESULT = "functionResult";
    private static final String PREFIX = Browser.class.getName();
    static final String EXECUTED_FUNCTION_NAME = PREFIX.concat("#executedFunctionName.");
    static final String EXECUTED_FUNCTION_RESULT = PREFIX.concat("#executedFunctionResult.");
    static final String EXECUTED_FUNCTION_ERROR = PREFIX.concat("#executedFunctionError.");
    private static final String FUNCTIONS_TO_CREATE = PREFIX.concat("#functionsToCreate.");
    private static final String FUNCTIONS_TO_DESTROY = PREFIX.concat("#functionsToDestroy.");

    @Override
    public void preserveValues(Browser browser) {
        WidgetLCAUtil.preserveListener(browser, "Progress", BrowserLCA.hasProgressListener(browser));
    }

    @Override
    public void renderInitialization(Browser browser) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(browser, TYPE);
        remoteObject.setHandler(new BrowserOperationHandler(browser));
        remoteObject.set("parent", WidgetUtil.getId(browser.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(browser, ALLOWED_STYLES)));
    }

    @Override
    public void renderChanges(final Browser browser) throws IOException {
        ControlLCAUtil.renderChanges(browser);
        WidgetLCAUtil.renderCustomVariant(browser);
        BrowserLCA.destroyBrowserFunctions(browser);
        BrowserLCA.renderUrl(browser);
        BrowserLCA.createBrowserFunctions(browser);
        BrowserLCA.renderAfterAll(browser.getDisplay(), new Runnable(){

            @Override
            public void run() {
                BrowserLCA.renderEvaluate(browser);
            }
        });
        BrowserLCA.renderFunctionResult(browser);
        WidgetLCAUtil.renderListener((Widget)browser, "Progress", BrowserLCA.hasProgressListener(browser), false);
    }

    private static void renderUrl(Browser browser) throws IOException {
        if (BrowserLCA.hasUrlChanged(browser)) {
            RemoteObjectFactory.getRemoteObject(browser).set("url", BrowserLCA.getUrl(browser));
            browser.getAdapter(IBrowserAdapter.class).resetUrlChanged();
        }
    }

    static boolean hasUrlChanged(Browser browser) {
        boolean initialized = WidgetUtil.getAdapter(browser).isInitialized();
        return !initialized || browser.getAdapter(IBrowserAdapter.class).hasUrlChanged();
    }

    static String getUrl(Browser browser) throws IOException {
        String text = BrowserLCA.getText(browser);
        String url = browser.getUrl();
        String result = !"".equals(text.trim()) ? BrowserLCA.registerHtml(text) : (!"".equals(url.trim()) ? url : BrowserLCA.registerHtml(BLANK_HTML));
        return result;
    }

    private static void renderAfterAll(Display display, Runnable runnable) {
        ((WidgetRemoteAdapter)DisplayUtil.getAdapter(display)).addRenderRunnable(runnable);
    }

    private static void renderEvaluate(Browser browser) {
        IBrowserAdapter adapter = browser.getAdapter(IBrowserAdapter.class);
        String executeScript = adapter.getExecuteScript();
        boolean executePending = adapter.getExecutePending();
        if (executeScript != null && !executePending) {
            JsonObject parameters = new JsonObject().add(PARAM_SCRIPT, executeScript);
            RemoteObjectFactory.getRemoteObject(browser).call(METHOD_EVALUATE, parameters);
            adapter.setExecutePending(true);
        }
    }

    private static String registerHtml(String html) throws IOException {
        String name = BrowserLCA.createUrlFromHtml(html);
        byte[] bytes = html.getBytes("UTF-8");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ResourceManager resourceManager = RWT.getResourceManager();
        resourceManager.register(name, inputStream);
        return resourceManager.getLocation(name);
    }

    private static String createUrlFromHtml(String html) {
        StringBuilder result = new StringBuilder();
        result.append("org.eclipse.swt.browser/text");
        result.append(String.valueOf(html.hashCode()));
        result.append(".html");
        return result.toString();
    }

    private static String getText(Browser browser) {
        IBrowserAdapter adapter;
        IBrowserAdapter browserAdapter = adapter = browser.getAdapter(IBrowserAdapter.class);
        return browserAdapter.getText();
    }

    private static void createBrowserFunctions(Browser browser) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        String id = WidgetUtil.getId(browser);
        String[] functions = (String[])serviceStore.getAttribute(String.valueOf(FUNCTIONS_TO_CREATE) + id);
        if (functions != null) {
            JsonObject parameters = new JsonObject().add(PARAM_FUNCTIONS, JsonUtil.createJsonArray(functions));
            RemoteObjectFactory.getRemoteObject(browser).call(METHOD_CREATE_FUNCTIONS, parameters);
        }
    }

    private static void destroyBrowserFunctions(Browser browser) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        String id = WidgetUtil.getId(browser);
        String[] functions = (String[])serviceStore.getAttribute(String.valueOf(FUNCTIONS_TO_DESTROY) + id);
        if (functions != null) {
            JsonObject parameters = new JsonObject().add(PARAM_FUNCTIONS, JsonUtil.createJsonArray(functions));
            RemoteObjectFactory.getRemoteObject(browser).call(METHOD_DESTROY_FUNCTIONS, parameters);
        }
    }

    private static void renderFunctionResult(Browser browser) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        String id = WidgetUtil.getId(browser);
        String name = (String)serviceStore.getAttribute(String.valueOf(EXECUTED_FUNCTION_NAME) + id);
        if (name != null) {
            JsonValue result = (JsonValue)serviceStore.getAttribute(String.valueOf(EXECUTED_FUNCTION_RESULT) + id);
            if (result == null) {
                result = JsonValue.NULL;
            }
            String error = (String)serviceStore.getAttribute(String.valueOf(EXECUTED_FUNCTION_ERROR) + id);
            JsonArray array = new JsonArray().add(name).add(result).add(error);
            RemoteObjectFactory.getRemoteObject(browser).set(PARAM_FUNCTION_RESULT, array);
        }
    }

    private static boolean hasProgressListener(Browser browser) {
        return EventLCAUtil.isListening(browser, 5021) || EventLCAUtil.isListening(browser, 5022);
    }

    private BrowserLCA() {
    }
}

