/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.service;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServletLog;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.service.FileSettingStore;
import org.eclipse.rap.rwt.service.SettingStore;
import org.eclipse.rap.rwt.service.SettingStoreFactory;

public final class FileSettingStoreFactory
implements SettingStoreFactory {
    private File directory;

    @Override
    public SettingStore createSettingStore(String id) {
        ParamCheck.notNullOrEmpty(id, "id");
        FileSettingStore store = new FileSettingStore(this.getWorkingDir());
        try {
            store.loadById(id);
        }
        catch (IOException sse) {
            ServletLog.log(sse.getMessage(), sse);
        }
        return store;
    }

    private File getWorkingDir() {
        if (this.directory == null) {
            this.directory = FileSettingStoreFactory.selectWorkingDir();
            FileSettingStoreFactory.createDirectory(this.directory);
        }
        return this.directory;
    }

    private static File selectWorkingDir() {
        File directory = FileSettingStoreFactory.getDirectoryFromServletContext();
        if (directory == null && (directory = FileSettingStoreFactory.getDirectoryFromServletContextTempDir()) == null) {
            directory = FileSettingStoreFactory.getDirectoryFromSystemTempDir();
        }
        return directory;
    }

    private static void createDirectory(File directory) {
        if (!directory.mkdirs() && !directory.isDirectory()) {
            String message = "Could not create directory: " + directory.getAbsolutePath();
            throw new IllegalArgumentException(message);
        }
    }

    private static File getDirectoryFromSystemTempDir() {
        String parent = System.getProperty("java.io.tmpdir");
        File result = new File(parent, FileSettingStore.class.getName());
        return result;
    }

    private static File getDirectoryFromServletContext() {
        String path = FileSettingStoreFactory.getServletContext().getInitParameter("org.eclipse.rap.rwt.service.FileSettingStore.dir");
        return path != null ? new File(path) : null;
    }

    private static File getDirectoryFromServletContextTempDir() {
        File parent = (File)FileSettingStoreFactory.getServletContext().getAttribute("javax.servlet.context.tempdir");
        return parent != null ? new File(parent, FileSettingStore.class.getName()) : null;
    }

    private static ServletContext getServletContext() {
        HttpSession session = ContextProvider.getRequest().getSession();
        return session.getServletContext();
    }
}

