/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.displaykit;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.ExitConfirmation;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rap.rwt.internal.lifecycle.DisposedWidgets;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rap.rwt.internal.lifecycle.EntryPointRegistration;
import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.ReparentedControls;
import org.eclipse.rap.rwt.internal.lifecycle.UITestUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.Operation;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectLifeCycleAdapter;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.textsize.MeasurementUtil;
import org.eclipse.rap.rwt.internal.util.ActiveKeysUtil;
import org.eclipse.swt.internal.widgets.ControlRemoteAdapter;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.WidgetRemoteAdapter;
import org.eclipse.swt.internal.widgets.WidgetTreeUtil;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.internal.widgets.displaykit.DNDSupport;
import org.eclipse.swt.internal.widgets.displaykit.DisplayOperationHandler;
import org.eclipse.swt.internal.widgets.displaykit.ServerPushRenderer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DisplayLCA {
    static final String PROP_FOCUS_CONTROL = "focusControl";
    static final String PROP_EXIT_CONFIRMATION = "exitConfirmation";
    private static final String METHOD_BEEP = "beep";
    private static final String PROP_RESIZE_LISTENER = "listener_Resize";

    public void readData(Display display) {
        DisplayLCA.handleOperations(display);
        DisplayLCA.visitWidgets(display);
        DNDSupport.handleOperations();
        RemoteObjectLifeCycleAdapter.readData(ProtocolUtil.getClientMessage());
    }

    public void preserveValues(Display display) {
        RemoteAdapter adapter = DisplayUtil.getAdapter(display);
        adapter.preserve(PROP_FOCUS_CONTROL, display.getFocusControl());
        adapter.preserve(PROP_EXIT_CONFIRMATION, DisplayLCA.getExitConfirmation());
        adapter.preserve(PROP_RESIZE_LISTENER, DisplayLCA.hasResizeListener(display));
        ActiveKeysUtil.preserveActiveKeys(display);
        ActiveKeysUtil.preserveCancelKeys(display);
        ActiveKeysUtil.preserveMnemonicActivator(display);
        if (adapter.isInitialized()) {
            Shell[] shellArray = DisplayLCA.getShells(display);
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                WidgetTreeUtil.accept(shell, new WidgetTreeVisitor(){

                    @Override
                    public boolean visit(Widget widget) {
                        WidgetUtil.getLCA(widget).preserveValues(widget);
                        return true;
                    }
                });
                ++n2;
            }
        }
    }

    public void render(Display display) throws IOException {
        DisplayLCA.renderOverflow(display);
        DisplayLCA.renderReparentControls();
        DisplayLCA.renderDisposeWidgets();
        DisplayLCA.renderExitConfirmation(display);
        DisplayLCA.renderEnableUiTests(display);
        DisplayLCA.renderShells(display);
        DisplayLCA.renderFocus(display);
        DisplayLCA.renderBeep(display);
        DisplayLCA.renderResizeListener(display);
        DisplayLCA.renderServerPush(display);
        ActiveKeysUtil.renderActiveKeys(display);
        ActiveKeysUtil.renderCancelKeys(display);
        ActiveKeysUtil.renderMnemonicActivator(display);
        RemoteObjectLifeCycleAdapter.render();
        MeasurementUtil.renderMeasurementItems();
        DisplayLCA.runRenderRunnables(display);
        DisplayLCA.markInitialized(display);
    }

    public void clearPreserved(Display display) {
        ((WidgetRemoteAdapter)DisplayUtil.getAdapter(display)).clearPreserved();
        Shell[] shellArray = DisplayLCA.getShells(display);
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            WidgetTreeUtil.accept(shell, new WidgetTreeVisitor(){

                @Override
                public boolean visit(Widget widget) {
                    ((WidgetRemoteAdapter)WidgetUtil.getAdapter(widget)).clearPreserved();
                    return true;
                }
            });
            ++n2;
        }
    }

    private static void handleOperations(Display display) {
        ClientMessage clientMessage = ProtocolUtil.getClientMessage();
        List<Operation> operations = clientMessage.getAllOperationsFor(DisplayUtil.getId(display));
        if (!operations.isEmpty()) {
            DisplayOperationHandler handler = new DisplayOperationHandler(display);
            for (Operation operation : operations) {
                ProtocolUtil.handleOperation(handler, operation);
            }
        }
    }

    private static void visitWidgets(Display display) {
        WidgetTreeVisitor visitor = new WidgetTreeVisitor(){

            @Override
            public boolean visit(Widget widget) {
                WidgetUtil.getLCA(widget).readData(widget);
                return true;
            }
        };
        Shell[] shellArray = DisplayLCA.getShells(display);
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            WidgetTreeUtil.accept(shell, visitor);
            ++n2;
        }
    }

    private static void renderOverflow(Display display) {
        String overflow;
        if (!DisplayUtil.getAdapter(display).isInitialized() && (overflow = DisplayLCA.getEntryPointProperties().get("org.eclipse.rap.rwt.webclient.pageOverflow")) != null) {
            RemoteObjectFactory.getRemoteObject(display).set("overflow", overflow);
        }
    }

    private static Map<String, String> getEntryPointProperties() {
        String servletPath;
        ApplicationContextImpl applicationContext = ContextProvider.getApplicationContext();
        EntryPointManager entryPointManager = applicationContext.getEntryPointManager();
        EntryPointRegistration registration = entryPointManager.getRegistrationByPath(servletPath = ContextProvider.getRequest().getServletPath());
        if (registration != null) {
            return registration.getProperties();
        }
        return Collections.emptyMap();
    }

    private static void renderShells(Display display) throws IOException {
        RenderVisitor visitor = new RenderVisitor();
        Shell[] shellArray = DisplayLCA.getShells(display);
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            WidgetTreeUtil.accept(shell, visitor);
            visitor.reThrowProblem();
            ++n2;
        }
    }

    private static void renderExitConfirmation(Display display) {
        boolean hasChanged;
        String exitConfirmation = DisplayLCA.getExitConfirmation();
        RemoteAdapter adapter = DisplayUtil.getAdapter(display);
        Object oldExitConfirmation = adapter.getPreserved(PROP_EXIT_CONFIRMATION);
        boolean bl = exitConfirmation == null ? oldExitConfirmation != null : (hasChanged = !exitConfirmation.equals(oldExitConfirmation));
        if (hasChanged) {
            RemoteObjectFactory.getRemoteObject(display).set(PROP_EXIT_CONFIRMATION, exitConfirmation);
        }
    }

    private static String getExitConfirmation() {
        ExitConfirmation exitConfirmation = RWT.getClient().getService(ExitConfirmation.class);
        return exitConfirmation == null ? null : exitConfirmation.getMessage();
    }

    private static void renderReparentControls() {
        for (Control control : ReparentedControls.getAll()) {
            if (control.isDisposed()) continue;
            DisplayLCA.getRemoteAdapter(control).renderParent(control);
        }
    }

    private static ControlRemoteAdapter getRemoteAdapter(Control control) {
        return (ControlRemoteAdapter)control.getAdapter(RemoteAdapter.class);
    }

    private static void renderDisposeWidgets() throws IOException {
        for (Widget widget : DisposedWidgets.getAll()) {
            WidgetUtil.getLCA(widget).renderDispose(widget);
        }
    }

    private static void renderFocus(Display display) {
        if (!display.isDisposed()) {
            Control focusControl;
            IDisplayAdapter displayAdapter = DisplayLCA.getDisplayAdapter(display);
            RemoteAdapter widgetAdapter = DisplayUtil.getAdapter(display);
            Object oldValue = widgetAdapter.getPreserved(PROP_FOCUS_CONTROL);
            if ((!widgetAdapter.isInitialized() || oldValue != display.getFocusControl() || displayAdapter.isFocusInvalidated()) && (focusControl = display.getFocusControl()) != null) {
                RemoteObjectFactory.getRemoteObject(display).set(PROP_FOCUS_CONTROL, WidgetUtil.getId(display.getFocusControl()));
            }
        }
    }

    private static void renderBeep(Display display) {
        IDisplayAdapter displayAdapter = DisplayLCA.getDisplayAdapter(display);
        if (displayAdapter.isBeepCalled()) {
            displayAdapter.resetBeep();
            RemoteObjectFactory.getRemoteObject(display).call(METHOD_BEEP, null);
        }
    }

    private static void renderResizeListener(Display display) {
        Boolean newValue;
        RemoteAdapter adapter = DisplayUtil.getAdapter(display);
        Boolean oldValue = (Boolean)adapter.getPreserved(PROP_RESIZE_LISTENER);
        if (oldValue == null) {
            oldValue = Boolean.FALSE;
        }
        if (!oldValue.equals(newValue = Boolean.valueOf(DisplayLCA.hasResizeListener(display)))) {
            RemoteObjectFactory.getRemoteObject(display).listen("Resize", newValue);
        }
    }

    private static void renderServerPush(Display display) {
        ServerPushRenderer serverPushRenderer = new ServerPushRenderer();
        if (display.isDisposed()) {
            serverPushRenderer.renderActivation(false);
        } else {
            serverPushRenderer.render();
        }
    }

    private static void renderEnableUiTests(Display display) {
        if (UITestUtil.isEnabled() && !DisplayUtil.getAdapter(display).isInitialized()) {
            RemoteObjectFactory.getRemoteObject(display).set("enableUiTests", true);
        }
    }

    private static void runRenderRunnables(Display display) {
        WidgetRemoteAdapter adapter = (WidgetRemoteAdapter)DisplayUtil.getAdapter(display);
        Runnable[] runnableArray = adapter.getRenderRunnables();
        int n = runnableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Runnable runnable = runnableArray[n2];
            runnable.run();
            ++n2;
        }
        adapter.clearRenderRunnables();
    }

    private static void markInitialized(Display display) {
        ((WidgetRemoteAdapter)DisplayUtil.getAdapter(display)).setInitialized(true);
    }

    private static boolean hasResizeListener(Display display) {
        return DisplayLCA.getDisplayAdapter(display).isListening(11);
    }

    private static IDisplayAdapter getDisplayAdapter(Display display) {
        return display.getAdapter(IDisplayAdapter.class);
    }

    private static Shell[] getShells(Display display) {
        return DisplayLCA.getDisplayAdapter(display).getShells();
    }

    private static final class RenderVisitor
    implements WidgetTreeVisitor {
        private IOException ioProblem;

        private RenderVisitor() {
        }

        @Override
        public boolean visit(Widget widget) {
            this.ioProblem = null;
            try {
                RenderVisitor.render(widget);
                RenderVisitor.runRenderRunnables(widget);
            }
            catch (IOException ioe) {
                this.ioProblem = ioe;
                return false;
            }
            return true;
        }

        private void reThrowProblem() throws IOException {
            if (this.ioProblem != null) {
                throw this.ioProblem;
            }
        }

        private static void render(Widget widget) throws IOException {
            WidgetUtil.getLCA(widget).render(widget);
        }

        private static void runRenderRunnables(Widget widget) {
            WidgetRemoteAdapter adapter = (WidgetRemoteAdapter)WidgetUtil.getAdapter(widget);
            Runnable[] runnableArray = adapter.getRenderRunnables();
            int n = runnableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Runnable runnable = runnableArray[n2];
                runnable.run();
                ++n2;
            }
            adapter.clearRenderRunnables();
        }
    }
}

