/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.LoggingCategory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SWTTeslaActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.rcptt.tesla.swt";
    private static SWTTeslaActivator plugin;
    public static boolean DEBUG_LOGGING_ENABLED;

    static {
        DEBUG_LOGGING_ENABLED = false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        DebugOptions service = null;
        ServiceReference reference = context.getServiceReference(DebugOptions.class.getName());
        if (reference != null) {
            service = (DebugOptions)context.getService(reference);
        }
        if (service == null) {
            return;
        }
        try {
            DEBUG_LOGGING_ENABLED = service.getBooleanOption("org.eclipse.rcptt.tesla.swt/logging", false);
        }
        finally {
            context.ungetService(reference);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static SWTTeslaActivator getDefault() {
        return plugin;
    }

    public static void info(String message) {
        SWTTeslaActivator.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static void log(Throwable t) {
        SWTTeslaActivator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, t.getMessage(), t));
    }

    public static void log(String message, Throwable t) {
        SWTTeslaActivator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message, t));
    }

    public static void log(String msg) {
        SWTTeslaActivator.getDefault().getLog().log((IStatus)new Status(2, PLUGIN_ID, msg, null));
    }

    public static void err(String msg) {
        SWTTeslaActivator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, msg, null));
    }

    public static IStatus createStatus(String message, Throwable t) {
        return new Status(4, PLUGIN_ID, message, t);
    }

    public static void debugLog(String message) {
        if (DEBUG_LOGGING_ENABLED) {
            System.out.println(message);
        }
    }

    public static void logToReport(String message) {
        INodeBuilder nodeBuilder = ReportManager.getCurrentReportNode();
        nodeBuilder.appendLog(LoggingCategory.NORMAL, message);
    }

    public static void logToReport(LoggingCategory category, String message) {
        try {
            INodeBuilder nodeBuilder = ReportManager.getCurrentReportNode();
            nodeBuilder.appendLog(category, message);
        }
        catch (Throwable e) {
            SWTTeslaActivator.log("Exception while writing to the report log.", e);
        }
    }
}

