/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.http;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

@Deprecated(forRemoval=true, since="Servlet 6.0")
class NoBodyOutputStream
extends ServletOutputStream {
    private static final String LSTRING_FILE = "jakarta.servlet.http.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("jakarta.servlet.http.LocalStrings");
    static ThreadLocal<Boolean> disableFlush = new ThreadLocal();
    private int contentLength = 0;

    NoBodyOutputStream() {
    }

    void reset() {
        this.contentLength = 0;
    }

    int getContentLength() {
        return this.contentLength;
    }

    @Override
    public void write(int b) {
        ++this.contentLength;
    }

    @Override
    public void write(byte[] buf, int offset, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException(lStrings.getString("err.io.nullArray"));
        }
        if (offset < 0 || len < 0 || offset + len > buf.length) {
            String msg = lStrings.getString("err.io.indexOutOfBounds");
            Object[] msgArgs = new Object[]{offset, len, buf.length};
            msg = MessageFormat.format(msg, msgArgs);
            throw new IndexOutOfBoundsException(msg);
        }
        this.contentLength += len;
    }

    @Override
    public void flush() throws IOException {
        if (Boolean.TRUE.equals(disableFlush.get())) {
            super.flush();
        }
    }

    @Override
    public boolean isReady() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWriteListener(WriteListener writeListener) {
        throw new UnsupportedOperationException();
    }
}

