/*******************************************************************************
 * Copyright (c) 2020 ArSysOp
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0/.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     ArSysOp - initial API and implementation
 *******************************************************************************/
package org.eclipse.passage.lic.floating.edit.providers;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.passage.lic.floating.model.util.FloatingAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class FloatingItemProviderAdapterFactory extends FloatingAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FloatingItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.floating.model.api.FloatingLicensePack} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FloatingLicensePackItemProvider floatingLicensePackItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.floating.model.api.FloatingLicensePack}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFloatingLicensePackAdapter() {
		if (floatingLicensePackItemProvider == null) {
			floatingLicensePackItemProvider = new FloatingLicensePackItemProvider(this);
		}

		return floatingLicensePackItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.floating.model.api.LicenseRequisites} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LicenseRequisitesItemProvider licenseRequisitesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.floating.model.api.LicenseRequisites}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLicenseRequisitesAdapter() {
		if (licenseRequisitesItemProvider == null) {
			licenseRequisitesItemProvider = new LicenseRequisitesItemProvider(this);
		}

		return licenseRequisitesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.floating.model.api.ProductRef} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProductRefItemProvider productRefItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.floating.model.api.ProductRef}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProductRefAdapter() {
		if (productRefItemProvider == null) {
			productRefItemProvider = new ProductRefItemProvider(this);
		}

		return productRefItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.floating.model.api.FloatingServer} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FloatingServerItemProvider floatingServerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.floating.model.api.FloatingServer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFloatingServerAdapter() {
		if (floatingServerItemProvider == null) {
			floatingServerItemProvider = new FloatingServerItemProvider(this);
		}

		return floatingServerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.floating.model.api.UserGrant} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected UserGrantItemProvider userGrantItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.floating.model.api.UserGrant}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createUserGrantAdapter() {
		if (userGrantItemProvider == null) {
			userGrantItemProvider = new UserGrantItemProvider(this);
		}

		return userGrantItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.floating.model.api.FeatureGrant} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureGrantItemProvider featureGrantItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.floating.model.api.FeatureGrant}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeatureGrantAdapter() {
		if (featureGrantItemProvider == null) {
			featureGrantItemProvider = new FeatureGrantItemProvider(this);
		}

		return featureGrantItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.floating.model.api.ValidityPeriodClosed} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ValidityPeriodClosedItemProvider validityPeriodClosedItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.floating.model.api.ValidityPeriodClosed}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createValidityPeriodClosedAdapter() {
		if (validityPeriodClosedItemProvider == null) {
			validityPeriodClosedItemProvider = new ValidityPeriodClosedItemProvider(this);
		}

		return validityPeriodClosedItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.floating.model.api.EvaluationInstructions} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EvaluationInstructionsItemProvider evaluationInstructionsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.floating.model.api.EvaluationInstructions}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEvaluationInstructionsAdapter() {
		if (evaluationInstructionsItemProvider == null) {
			evaluationInstructionsItemProvider = new EvaluationInstructionsItemProvider(this);
		}

		return evaluationInstructionsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.floating.model.api.VersionMatch} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VersionMatchItemProvider versionMatchItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.floating.model.api.VersionMatch}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVersionMatchAdapter() {
		if (versionMatchItemProvider == null) {
			versionMatchItemProvider = new VersionMatchItemProvider(this);
		}

		return versionMatchItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.floating.model.api.FloatingLicenseAccess} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FloatingLicenseAccessItemProvider floatingLicenseAccessItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.floating.model.api.FloatingLicenseAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFloatingLicenseAccessAdapter() {
		if (floatingLicenseAccessItemProvider == null) {
			floatingLicenseAccessItemProvider = new FloatingLicenseAccessItemProvider(this);
		}

		return floatingLicenseAccessItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.floating.model.api.FloatingServerConnection} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FloatingServerConnectionItemProvider floatingServerConnectionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.floating.model.api.FloatingServerConnection}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFloatingServerConnectionAdapter() {
		if (floatingServerConnectionItemProvider == null) {
			floatingServerConnectionItemProvider = new FloatingServerConnectionItemProvider(this);
		}

		return floatingServerConnectionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.passage.lic.floating.model.api.GrantAcqisition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GrantAcqisitionItemProvider grantAcqisitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.passage.lic.floating.model.api.GrantAcqisition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGrantAcqisitionAdapter() {
		if (grantAcqisitionItemProvider == null) {
			grantAcqisitionItemProvider = new GrantAcqisitionItemProvider(this);
		}

		return grantAcqisitionItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (floatingLicensePackItemProvider != null)
			floatingLicensePackItemProvider.dispose();
		if (licenseRequisitesItemProvider != null)
			licenseRequisitesItemProvider.dispose();
		if (productRefItemProvider != null)
			productRefItemProvider.dispose();
		if (floatingServerItemProvider != null)
			floatingServerItemProvider.dispose();
		if (userGrantItemProvider != null)
			userGrantItemProvider.dispose();
		if (featureGrantItemProvider != null)
			featureGrantItemProvider.dispose();
		if (validityPeriodClosedItemProvider != null)
			validityPeriodClosedItemProvider.dispose();
		if (evaluationInstructionsItemProvider != null)
			evaluationInstructionsItemProvider.dispose();
		if (versionMatchItemProvider != null)
			versionMatchItemProvider.dispose();
		if (floatingLicenseAccessItemProvider != null)
			floatingLicenseAccessItemProvider.dispose();
		if (floatingServerConnectionItemProvider != null)
			floatingServerConnectionItemProvider.dispose();
		if (grantAcqisitionItemProvider != null)
			grantAcqisitionItemProvider.dispose();
	}

}
