/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm.aspect;

import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.packagedrone.repo.channel.PreAddContext;
import org.eclipse.packagedrone.repo.channel.Veto;
import org.eclipse.packagedrone.repo.channel.apm.aspect.AspectableContext;
import org.eclipse.packagedrone.repo.channel.search.ArtifactLocator;
import org.eclipse.packagedrone.repo.channel.search.stream.StreamArtifactLocator;

public class PreAddContextImpl
implements PreAddContext {
    private final String name;
    private final Path file;
    private final boolean external;
    private Veto veto;
    private final AspectableContext context;

    public PreAddContextImpl(String name, Path file, boolean external, AspectableContext context) {
        this.name = name;
        this.file = file;
        this.external = external;
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    public Path getFile() {
        return this.file;
    }

    public void vetoAdd(Veto veto) {
        Objects.requireNonNull(veto);
        if (this.veto == null) {
            this.veto = veto;
        } else if (this.veto.getPolicy().ordinal() < veto.getPolicy().ordinal()) {
            this.veto = veto;
        }
    }

    public Veto getVeto() {
        return this.veto;
    }

    public boolean isExternal() {
        return this.external;
    }

    public ArtifactLocator getArtifactLocator() {
        return new StreamArtifactLocator(() -> this.context.getArtifacts().values().stream());
    }
}

