/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm.build;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.eclipse.packagedrone.utils.rpm.Architecture;
import org.eclipse.packagedrone.utils.rpm.FileFlags;
import org.eclipse.packagedrone.utils.rpm.OperatingSystem;
import org.eclipse.packagedrone.utils.rpm.PathName;
import org.eclipse.packagedrone.utils.rpm.RpmLead;
import org.eclipse.packagedrone.utils.rpm.RpmTag;
import org.eclipse.packagedrone.utils.rpm.RpmVersion;
import org.eclipse.packagedrone.utils.rpm.Rpms;
import org.eclipse.packagedrone.utils.rpm.build.BuilderContext;
import org.eclipse.packagedrone.utils.rpm.build.BuilderOptions;
import org.eclipse.packagedrone.utils.rpm.build.FileInformation;
import org.eclipse.packagedrone.utils.rpm.build.FileInformationProvider;
import org.eclipse.packagedrone.utils.rpm.build.LeadBuilder;
import org.eclipse.packagedrone.utils.rpm.build.LongMode;
import org.eclipse.packagedrone.utils.rpm.build.PayloadEntryType;
import org.eclipse.packagedrone.utils.rpm.build.PayloadRecorder;
import org.eclipse.packagedrone.utils.rpm.build.RpmWriter;
import org.eclipse.packagedrone.utils.rpm.deps.Dependencies;
import org.eclipse.packagedrone.utils.rpm.deps.Dependency;
import org.eclipse.packagedrone.utils.rpm.deps.RpmDependencyFlags;
import org.eclipse.packagedrone.utils.rpm.header.Header;
import org.eclipse.packagedrone.utils.rpm.signature.SignatureProcessor;
import org.eclipse.packagedrone.utils.rpm.signature.SignatureProcessors;

public class RpmBuilder
implements AutoCloseable {
    private static final String DEFAULT_INTERPRETER = "/bin/sh";
    protected final Header<RpmTag> header = new Header();
    private final String name;
    private final RpmVersion version;
    private final String architecture;
    protected final PayloadRecorder recorder;
    private final Path targetFile;
    private final Set<Dependency> provides = new HashSet<Dependency>();
    private final Set<Dependency> requirements = new HashSet<Dependency>();
    private final Set<Dependency> conflicts = new HashSet<Dependency>();
    private final Set<Dependency> obsoletes = new HashSet<Dependency>();
    private final Map<String, FileEntry> files = new HashMap<String, FileEntry>();
    private PackageInformation information = new PackageInformation();
    private boolean hasBuilt;
    private int currentInode = 1;
    private final List<SignatureProcessor> signatureProcessors = new LinkedList<SignatureProcessor>();
    private final BuilderOptions options;
    private Architecture leadOverrideArchitecture;
    private OperatingSystem leadOverrideOperatingSystem;

    public RpmBuilder(String name, String version, String release, Path target) throws IOException {
        this(name, version, release, "noarch", target, new OpenOption[0]);
    }

    public RpmBuilder(String name, RpmVersion version, String architecture, Path targetFile, OpenOption ... openOptions) throws IOException {
        this(name, version, architecture, targetFile, RpmBuilder.makeBuilderOptions(openOptions));
    }

    private static BuilderOptions makeBuilderOptions(OpenOption[] openOptions) {
        BuilderOptions options = new BuilderOptions();
        options.setOpenOptions(openOptions);
        return options;
    }

    public RpmBuilder(String name, RpmVersion version, String architecture, Path targetFile, BuilderOptions options) throws IOException {
        this.name = name;
        this.version = version;
        this.architecture = architecture;
        this.options = options == null ? new BuilderOptions() : new BuilderOptions(options);
        this.targetFile = this.makeTargetFile(targetFile);
        this.recorder = new PayloadRecorder(true);
        this.addDefaultSignatureProcessors();
    }

    public RpmBuilder(String name, String version, String release, String architecture, Path target, OpenOption ... openOptions) throws IOException {
        this(name, new RpmVersion(null, version, release), architecture, target, openOptions);
    }

    public void addSignatureProcessor(SignatureProcessor processor) {
        this.signatureProcessors.add(processor);
    }

    public void removeAllSignatureProcessors() {
        this.signatureProcessors.clear();
    }

    public void addDefaultSignatureProcessors() {
        this.addSignatureProcessor(SignatureProcessors.size());
        this.addSignatureProcessor(SignatureProcessors.md5());
        this.addSignatureProcessor(SignatureProcessors.sha1Header());
        this.addSignatureProcessor(SignatureProcessors.payloadSize());
    }

    public void setLeadOverrideArchitecture(Architecture leadOverrideArchitecture) {
        this.leadOverrideArchitecture = leadOverrideArchitecture;
    }

    public void setLeadOverrideOperatingSystem(OperatingSystem leadOverrideOperatingSystem) {
        this.leadOverrideOperatingSystem = leadOverrideOperatingSystem;
    }

    private void fillRequirements() {
        this.requirements.add(new Dependency("rpmlib(PayloadFilesHavePrefix)", "4.0-1", RpmDependencyFlags.LESS, RpmDependencyFlags.EQUAL, RpmDependencyFlags.RPMLIB));
        this.requirements.add(new Dependency("rpmlib(CompressedFileNames)", "3.0.4-1", RpmDependencyFlags.LESS, RpmDependencyFlags.EQUAL, RpmDependencyFlags.RPMLIB));
    }

    private void fillProvides() {
        this.provides.add(new Dependency(this.name, this.version.toString(), RpmDependencyFlags.EQUAL));
    }

    private void fillHeader() {
        this.header.putString(RpmTag.PAYLOAD_FORMAT, "cpio");
        this.header.putString(RpmTag.PAYLOAD_CODING, "gzip");
        this.header.putString(RpmTag.PAYLOAD_FLAGS, "9");
        this.header.putStringArray(100, "C");
        this.header.putString(RpmTag.NAME, this.name);
        this.header.putString(RpmTag.VERSION, this.version.getVersion());
        if (this.version.getRelease().isPresent()) {
            this.header.putString(RpmTag.RELEASE, this.version.getRelease().get());
        }
        if (this.version.getEpoch().isPresent()) {
            this.header.putInt(RpmTag.EPOCH, this.version.getEpoch().get());
        }
        this.header.putString(RpmTag.LICENSE, this.information.getLicense());
        this.header.putStringOptional(RpmTag.DISTRIBUTION, this.information.getDistribution());
        this.header.putStringOptional(RpmTag.PACKAGER, this.information.getPackager());
        this.header.putStringOptional(RpmTag.VENDOR, this.information.getVendor());
        this.header.putStringOptional(RpmTag.URL, this.information.getUrl());
        this.header.putInt(RpmTag.BUILDTIME, (int)(System.currentTimeMillis() / 1000L));
        this.header.putString(RpmTag.BUILDHOST, this.information.getBuildHost());
        this.header.putI18nString(RpmTag.SUMMARY, this.information.getSummary());
        this.header.putI18nString(RpmTag.DESCRIPTION, this.information.getDescription());
        this.header.putI18nString(RpmTag.GROUP, this.information.getGroup());
        this.header.putString(RpmTag.ARCH, this.architecture);
        this.header.putString(RpmTag.OS, this.information.getOperatingSystem());
        Dependencies.putProvides(this.header, this.provides);
        Dependencies.putRequirements(this.header, this.requirements);
        Dependencies.putConflicts(this.header, this.conflicts);
        Dependencies.putObsoletes(this.header, this.obsoletes);
        if (!this.files.isEmpty()) {
            FileEntry[] files = this.files.values().toArray(new FileEntry[this.files.size()]);
            Arrays.sort(files, Comparator.comparing(FileEntry::getTargetName));
            long installedSize = Arrays.stream(files).mapToLong(FileEntry::getTargetSize).sum();
            this.header.putSize(installedSize, RpmTag.SIZE, RpmTag.LONGSIZE);
            List<FileEntry> filesList = Arrays.asList(files);
            Header.putIntFields(this.header, filesList, RpmTag.FILE_SIZES, entry -> (int)entry.getSize());
            Header.putShortFields(this.header, filesList, RpmTag.FILE_MODES, FileEntry::getMode);
            Header.putShortFields(this.header, filesList, RpmTag.FILE_RDEVS, FileEntry::getRdevs);
            Header.putIntFields(this.header, filesList, RpmTag.FILE_MTIMES, FileEntry::getModificationTime);
            Header.putFields(this.header, filesList, RpmTag.FILE_DIGESTS, String[]::new, FileEntry::getDigest, (header, rpmTag, stringArray) -> header.putStringArray(rpmTag, (String[])stringArray));
            Header.putFields(this.header, filesList, RpmTag.FILE_LINKTO, String[]::new, FileEntry::getLinkTo, (header, rpmTag, stringArray) -> header.putStringArray(rpmTag, (String[])stringArray));
            Header.putIntFields(this.header, filesList, RpmTag.FILE_FLAGS, FileEntry::getFlags);
            Header.putFields(this.header, filesList, RpmTag.FILE_USERNAME, String[]::new, FileEntry::getUser, (header, rpmTag, stringArray) -> header.putStringArray(rpmTag, (String[])stringArray));
            Header.putFields(this.header, filesList, RpmTag.FILE_GROUPNAME, String[]::new, FileEntry::getGroup, (header, rpmTag, stringArray) -> header.putStringArray(rpmTag, (String[])stringArray));
            Header.putIntFields(this.header, filesList, RpmTag.FILE_VERIFYFLAGS, FileEntry::getVerifyFlags);
            RpmBuilder.putNumber(this.options.getLongMode(), this.header, filesList, RpmTag.FILE_DEVICES, FileEntry::getDevice);
            RpmBuilder.putNumber(this.options.getLongMode(), this.header, filesList, RpmTag.FILE_INODES, FileEntry::getInode);
            Header.putFields(this.header, filesList, RpmTag.FILE_LANGS, String[]::new, FileEntry::getLang, (header, rpmTag, stringArray) -> header.putStringArray(rpmTag, (String[])stringArray));
            Header.putFields(this.header, filesList, RpmTag.BASENAMES, String[]::new, fe -> fe.getTargetName().getBasename(), (header, rpmTag, stringArray) -> header.putStringArray(rpmTag, (String[])stringArray));
            String currentDirName = null;
            ArrayList<String> dirnames = new ArrayList<String>();
            int[] dirIndexes = new int[files.length];
            int pos = -1;
            int i = 0;
            FileEntry[] fileEntryArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                FileEntry f = fileEntryArray[n2];
                String dirname = f.getTargetName().getDirname();
                if (currentDirName == null || !currentDirName.equals(dirname)) {
                    currentDirName = dirname;
                    if (!dirname.isEmpty()) {
                        dirnames.add("/" + dirname + "/");
                    } else {
                        dirnames.add("/");
                    }
                }
                dirIndexes[i] = ++pos;
                ++i;
                ++n2;
            }
            this.header.putInt(RpmTag.DIR_INDEXES, dirIndexes);
            this.header.putStringArray(RpmTag.DIRNAMES, dirnames.toArray(new String[dirnames.size()]));
        } else {
            this.header.putSize(0L, RpmTag.SIZE, RpmTag.LONGSIZE);
        }
    }

    private static void putNumber(LongMode longMode, Header<RpmTag> header, Collection<FileEntry> files, RpmTag tag, ToLongFunction<FileEntry> func) {
        boolean useLong;
        if (longMode == LongMode.FORCE_64BIT) {
            useLong = true;
        } else {
            boolean needLong = RpmBuilder.needLong(files, func);
            if (longMode == LongMode.FORCE_32BIT) {
                if (needLong) {
                    throw new IllegalStateException("Requested 32bit mode, but 64bit is necessary");
                }
                useLong = false;
            } else {
                useLong = needLong;
            }
        }
        if (useLong) {
            Header.putLongFields(header, files, tag, func);
        } else {
            Header.putIntFields(header, files, tag, file -> (int)func.applyAsLong((FileEntry)file));
        }
    }

    private static boolean needLong(Collection<FileEntry> files, ToLongFunction<FileEntry> func) {
        return files.stream().anyMatch(file -> func.applyAsLong((FileEntry)file) > Integer.MAX_VALUE);
    }

    private Path makeTargetFile(Path target) {
        if (Files.isDirectory(target, new LinkOption[0])) {
            return target.resolve(this.makeDefaultFileName());
        }
        return target;
    }

    private String makeDefaultFileName() {
        StringBuilder sb = new StringBuilder(RpmLead.toLeadName(this.name, this.version));
        sb.append('-').append(this.architecture).append(".rpm");
        return sb.toString();
    }

    public PackageInformation getInformation() {
        return this.information;
    }

    public void setInformation(PackageInformation information) {
        this.information = information != null ? information : new PackageInformation();
    }

    public Path getTargetFile() {
        return this.targetFile;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public RpmVersion getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public void build() throws IOException {
        if (this.hasBuilt) {
            throw new IllegalStateException("RPM file has already been built. Can only be built once.");
        }
        this.hasBuilt = true;
        this.fillProvides();
        this.fillRequirements();
        this.fillHeader();
        LeadBuilder leadBuilder = new LeadBuilder(this.name, this.version);
        leadBuilder.fillFlagsFromHeader(this.header, this.createLeadArchitectureMapper(), this.createLeadOperatingSystemMapper());
        Throwable throwable = null;
        Object var3_4 = null;
        try (RpmWriter writer = new RpmWriter(this.targetFile, leadBuilder, this.header, this.options.getOpenOptions());){
            writer.addAllSignatureProcessors(this.signatureProcessors);
            writer.setPayload(this.recorder);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Function<String, Optional<Architecture>> createLeadArchitectureMapper() {
        if (this.leadOverrideArchitecture != null) {
            return s -> Optional.of(this.leadOverrideArchitecture);
        }
        return Architecture::fromAlias;
    }

    private Function<String, Optional<OperatingSystem>> createLeadOperatingSystemMapper() {
        if (this.leadOverrideOperatingSystem != null) {
            return s -> Optional.of(this.leadOverrideOperatingSystem);
        }
        return OperatingSystem::fromAlias;
    }

    @Override
    public void close() throws IOException {
        this.recorder.close();
    }

    public void addRequirement(String name, String version, RpmDependencyFlags ... flags) {
        this.requirements.add(new Dependency(name, version, flags));
    }

    public void addProvides(String name, String version, RpmDependencyFlags ... flags) {
        this.provides.add(new Dependency(name, version, flags));
    }

    public void addConflicts(String name, String version, RpmDependencyFlags ... flags) {
        this.conflicts.add(new Dependency(name, version, flags));
    }

    public void addObsoletes(String name, String version, RpmDependencyFlags ... flags) {
        this.obsoletes.add(new Dependency(name, version, flags));
    }

    private void addFile(String targetName, Path sourcePath, int mode, Instant mtime, Consumer<FileEntry> customizer) throws IOException {
        this.addFile(targetName, sourcePath, customizer, mode, mtime, PayloadRecorder::addFile);
    }

    private <T> void addFile(String targetName, T sourcePath, Consumer<FileEntry> customizer, int mode, Instant fileModificationInstant, RecorderFunction<T> func) throws IOException {
        PathName pathName = PathName.parse(targetName);
        long mtime = fileModificationInstant.getEpochSecond();
        int inode = this.currentInode++;
        short smode = (short)(mode | 0x8000);
        PayloadRecorder.Result result = func.record(this.recorder, "./" + pathName.toString(), sourcePath, this.cpioCustomizer(mtime, inode, smode));
        Consumer<FileEntry> c = this::initEntry;
        c = c.andThen(entry -> {
            entry.setModificationTime((int)mtime);
            entry.setInode(inode);
            entry.setMode(smode);
        });
        if (customizer != null) {
            c = c.andThen(customizer);
        }
        this.addResult(pathName, result, c);
    }

    private void addDirectory(String targetName, int mode, Instant modInstant, Consumer<FileEntry> customizer) throws IOException {
        PathName pathName = PathName.parse(targetName);
        long mtime = modInstant.getEpochSecond();
        int inode = this.currentInode++;
        short smode = (short)(mode | 0x4000);
        PayloadRecorder.Result result = this.recorder.addDirectory("./" + pathName.toString(), this.cpioCustomizer(mtime, inode, smode));
        Consumer<FileEntry> c = this::initEntry;
        c = c.andThen(entry -> {
            entry.setModificationTime((int)mtime);
            entry.setInode(inode);
            entry.setMode(smode);
            entry.setSize(0L);
            entry.setTargetSize(4096L);
        });
        if (customizer != null) {
            c = c.andThen(customizer);
        }
        this.addResult(pathName, result, c);
    }

    private void addSymbolicLink(String targetName, String linkTo, int mode, Instant modInstant, Consumer<FileEntry> customizer) throws IOException {
        PathName pathName = PathName.parse(targetName);
        long mtime = modInstant.getEpochSecond();
        int inode = this.currentInode++;
        short smode = (short)(mode | 0xA000);
        PayloadRecorder.Result result = this.recorder.addSymbolicLink("./" + pathName.toString(), linkTo, this.cpioCustomizer(mtime, inode, smode));
        Consumer<FileEntry> c = this::initEntry;
        c = c.andThen(entry -> {
            entry.setModificationTime((int)mtime);
            entry.setInode(inode);
            entry.setMode(smode);
            entry.setSize(result.getSize());
            entry.setTargetSize(result.getSize());
            entry.setLinkTo(linkTo);
        });
        if (customizer != null) {
            c = c.andThen(customizer);
        }
        this.addResult(pathName, result, c);
    }

    private void addFile(String targetName, InputStream stream, int mode, Instant modInstant, Consumer<FileEntry> customizer) throws IOException {
        this.addFile(targetName, stream, customizer, mode, modInstant, PayloadRecorder::addFile);
    }

    private void addFile(String targetName, ByteBuffer data, int mode, Instant modInstant, Consumer<FileEntry> customizer) throws IOException {
        this.addFile(targetName, data, customizer, mode, modInstant, PayloadRecorder::addFile);
    }

    private Consumer<CpioArchiveEntry> cpioCustomizer(long mtime, int inode, short mode) {
        return entry -> {
            entry.setTime(mtime);
            entry.setInode((long)inode);
            entry.setMode((long)(mode & 0xFFFF));
            entry.setDeviceMaj(8L);
            entry.setDeviceMin(17L);
        };
    }

    private void initEntry(FileEntry entry) {
        entry.setDevice(1);
        entry.setModificationTime((int)(System.currentTimeMillis() / 1000L));
    }

    private void addResult(PathName targetName, PayloadRecorder.Result result, Consumer<FileEntry> customizer) {
        FileEntry entry = new FileEntry();
        entry.setSize(result.getSize());
        entry.setTargetSize(result.getSize());
        entry.setDigest(result.getSha1() != null ? Rpms.toHex(result.getSha1()).toLowerCase() : "");
        entry.setTargetName(targetName);
        if (customizer != null) {
            customizer.accept(entry);
        }
        this.files.put(targetName.toString(), entry);
    }

    public BuilderContext newContext() {
        return new BuilderContextImpl(){

            @Override
            public void addFile(String targetName, Path source, FileInformationProvider<? super Path> provider) throws IOException {
                if (!Files.isRegularFile(source, new LinkOption[0])) {
                    throw new IllegalArgumentException(String.format("'%s' is not a regular file", source));
                }
                FileInformation info = this.makeInformation(targetName, source, PayloadEntryType.FILE, provider);
                RpmBuilder.this.addFile(targetName, source, info.getMode(), info.getTimestamp(), (Consumer<FileEntry>)entry -> this.customizeFile((FileEntry)entry, info));
            }

            @Override
            public void addFile(String targetName, InputStream source, FileInformationProvider<Object> provider) throws IOException {
                FileInformation info = this.makeInformation(targetName, source, PayloadEntryType.FILE, provider);
                RpmBuilder.this.addFile(targetName, source, info.getMode(), info.getTimestamp(), (Consumer<FileEntry>)entry -> this.customizeFile((FileEntry)entry, info));
            }

            @Override
            public void addFile(String targetName, ByteBuffer source, FileInformationProvider<Object> provider) throws IOException {
                FileInformation info = this.makeInformation(targetName, source, PayloadEntryType.FILE, provider);
                RpmBuilder.this.addFile(targetName, source, info.getMode(), info.getTimestamp(), (Consumer<FileEntry>)entry -> this.customizeFile((FileEntry)entry, info));
            }

            @Override
            public void addDirectory(String targetName, FileInformationProvider<? super BuilderContext.Directory> provider) throws IOException {
                FileInformation info = this.makeInformation(targetName, BuilderContext.DIRECTORY, PayloadEntryType.DIRECTORY, provider);
                RpmBuilder.this.addDirectory(targetName, info.getMode(), info.getTimestamp(), entry -> this.customizeDirectory((FileEntry)entry, info));
            }

            @Override
            public void addSymbolicLink(String targetName, String linkTo, FileInformationProvider<? super BuilderContext.SymbolicLink> provider) throws IOException {
                FileInformation info = this.makeInformation(targetName, BuilderContext.SYMBOLIC_LINK, PayloadEntryType.SYMBOLIC_LINK, provider);
                RpmBuilder.this.addSymbolicLink(targetName, linkTo, info.getMode(), info.getTimestamp(), entry -> this.customizeSymbolicLink((FileEntry)entry, info));
            }
        };
    }

    public void setPreInstallationScript(String interpreter, String script) {
        this.addRequirement(interpreter, null, RpmDependencyFlags.INTERPRETER);
        this.addRequirement(interpreter, null, RpmDependencyFlags.SCRIPT_PRE, RpmDependencyFlags.INTERPRETER);
        this.setScript(RpmTag.PREINSTALL_SCRIPT_PROG, RpmTag.PREINSTALL_SCRIPT, interpreter, script);
    }

    public void setPreInstallationScript(String script) {
        this.setPreInstallationScript(DEFAULT_INTERPRETER, script);
    }

    public void setPostInstallationScript(String interpreter, String script) {
        this.addRequirement(interpreter, null, RpmDependencyFlags.INTERPRETER);
        this.addRequirement(interpreter, null, RpmDependencyFlags.SCRIPT_POST, RpmDependencyFlags.INTERPRETER);
        this.setScript(RpmTag.POSTINSTALL_SCRIPT_PROG, RpmTag.POSTINSTALL_SCRIPT, interpreter, script);
    }

    public void setPostInstallationScript(String script) {
        this.setPostInstallationScript(DEFAULT_INTERPRETER, script);
    }

    public void setPreRemoveScript(String interpreter, String script) {
        this.addRequirement(interpreter, null, RpmDependencyFlags.INTERPRETER);
        this.addRequirement(interpreter, null, RpmDependencyFlags.SCRIPT_PREUN, RpmDependencyFlags.INTERPRETER);
        this.setScript(RpmTag.PREREMOVE_SCRIPT_PROG, RpmTag.PREREMOVE_SCRIPT, interpreter, script);
    }

    public void setPreRemoveScript(String script) {
        this.setPreRemoveScript(DEFAULT_INTERPRETER, script);
    }

    public void setPostRemoveScript(String interpreter, String script) {
        this.addRequirement(interpreter, null, RpmDependencyFlags.INTERPRETER);
        this.addRequirement(interpreter, null, RpmDependencyFlags.SCRIPT_POSTUN, RpmDependencyFlags.INTERPRETER);
        this.setScript(RpmTag.POSTREMOVE_SCRIPT_PROG, RpmTag.POSTREMOVE_SCRIPT, interpreter, script);
    }

    public void setPostRemoveScript(String script) {
        this.setPostRemoveScript(DEFAULT_INTERPRETER, script);
    }

    public void setVerifyScript(String interpreter, String script) {
        this.addRequirement(interpreter, null, RpmDependencyFlags.INTERPRETER);
        this.addRequirement(interpreter, null, RpmDependencyFlags.SCRIPT_VERIFY, RpmDependencyFlags.INTERPRETER);
        this.setScript(RpmTag.VERIFY_SCRIPT_PROG, RpmTag.VERIFY_SCRIPT, interpreter, script);
    }

    public void setVerifyScript(String script) {
        this.setVerifyScript(DEFAULT_INTERPRETER, script);
    }

    private void setScript(RpmTag interpreterTag, RpmTag scriptTag, String interpreter, String script) {
        if (interpreter == null || script == null) {
            this.header.remove(interpreterTag);
            this.header.remove(scriptTag);
        } else {
            this.header.putString(interpreterTag, interpreter);
            this.header.putString(scriptTag, script);
        }
    }

    private static abstract class BuilderContextImpl
    implements BuilderContext {
        private FileInformationProvider<Object> defaultProvider = BuilderContext.defaultProvider();

        private BuilderContextImpl() {
        }

        @Override
        public void setDefaultInformationProvider(FileInformationProvider<Object> provider) {
            this.defaultProvider = provider;
        }

        @Override
        public FileInformationProvider<Object> getDefaultInformationProvider() {
            return this.defaultProvider;
        }

        protected <T> FileInformation makeInformation(String targetName, T source, PayloadEntryType type, FileInformationProvider<T> provider) throws IOException {
            if (provider != null) {
                return provider.provide(targetName, source, type);
            }
            if (this.defaultProvider != null) {
                return this.defaultProvider.provide(targetName, source, type);
            }
            throw new IllegalStateException("There was neither a default provider nor a specfic provider set");
        }

        private static String getNotEmptyOrDefault(String value, String defaultValue) {
            if (value == null || value.isEmpty()) {
                return defaultValue;
            }
            return value;
        }

        protected void customizeCommon(FileEntry entry, FileInformation information) {
            entry.setUser(BuilderContextImpl.getNotEmptyOrDefault(information.getUser(), "root"));
            entry.setGroup(BuilderContextImpl.getNotEmptyOrDefault(information.getGroup(), "root"));
        }

        protected void customizeDirectory(FileEntry entry, FileInformation information) {
            this.customizeCommon(entry, information);
        }

        protected void customizeFile(FileEntry entry, FileInformation information) {
            this.customizeCommon(entry, information);
            if (!information.getFileFlags().isEmpty()) {
                for (FileFlags fileFlag : information.getFileFlags()) {
                    entry.setFlags(entry.getFlags() | fileFlag.getValue());
                }
            }
        }

        protected void customizeSymbolicLink(FileEntry entry, FileInformation information) {
            this.customizeCommon(entry, information);
        }
    }

    public static class FileEntry {
        private long size;
        private String user;
        private String group;
        private String linkTo;
        private short mode;
        private short rdevs;
        private int flags;
        private int modificationTime;
        private String digest;
        private int verifyFlags = -1;
        private String lang;
        private int device;
        private int inode;
        private PathName targetName;
        private long targetSize;

        public void setSize(long size) {
            this.size = size;
        }

        public long getSize() {
            return this.size;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getUser() {
            return this.user;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getGroup() {
            return this.group;
        }

        public void setLinkTo(String linkTo) {
            this.linkTo = linkTo;
        }

        public String getLinkTo() {
            return this.linkTo;
        }

        public short getMode() {
            return this.mode;
        }

        public void setMode(short mode) {
            this.mode = mode;
        }

        public short getRdevs() {
            return this.rdevs;
        }

        public void setRdevs(short rdevs) {
            this.rdevs = rdevs;
        }

        public int getFlags() {
            return this.flags;
        }

        public void setFlags(int flags) {
            this.flags = flags;
        }

        public void setModificationTime(int modificationTime) {
            this.modificationTime = modificationTime;
        }

        public int getModificationTime() {
            return this.modificationTime;
        }

        public void setDigest(String digest) {
            this.digest = digest;
        }

        public String getDigest() {
            return this.digest;
        }

        public void setVerifyFlags(int verifyFlags) {
            this.verifyFlags = verifyFlags;
        }

        public int getVerifyFlags() {
            return this.verifyFlags;
        }

        public void setLang(String lang) {
            this.lang = lang;
        }

        public String getLang() {
            return this.lang;
        }

        public void setDevice(int device) {
            this.device = device;
        }

        public int getDevice() {
            return this.device;
        }

        public void setInode(int inode) {
            this.inode = inode;
        }

        public int getInode() {
            return this.inode;
        }

        public void setTargetName(PathName targetName) {
            this.targetName = targetName;
        }

        public PathName getTargetName() {
            return this.targetName;
        }

        public void setTargetSize(long targetSize) {
            this.targetSize = targetSize;
        }

        public long getTargetSize() {
            return this.targetSize;
        }
    }

    public static class PackageInformation {
        private String distribution;
        private String packager;
        private String vendor;
        private String license = "unspecified";
        private String buildHost = "localhost";
        private String summary = "Unspecified";
        private String description = "Unspecified";
        private String group = "Unspecified";
        private String operatingSystem = "linux";
        private String url;

        public void setDistribution(String distribution) {
            this.distribution = distribution;
        }

        public String getDistribution() {
            return this.distribution;
        }

        public String getPackager() {
            return this.packager;
        }

        public void setPackager(String packager) {
            this.packager = packager;
        }

        public String getVendor() {
            return this.vendor;
        }

        public void setVendor(String vendor) {
            this.vendor = vendor;
        }

        public void setLicense(String license) {
            this.license = license;
        }

        public String getLicense() {
            return this.license;
        }

        public void setBuildHost(String buildHost) {
            this.buildHost = buildHost;
        }

        public String getBuildHost() {
            return this.buildHost;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setSummary(String summary) {
            this.summary = summary;
        }

        public String getSummary() {
            return this.summary;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getGroup() {
            return this.group;
        }

        public void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public String getOperatingSystem() {
            return this.operatingSystem;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }
    }

    @FunctionalInterface
    private static interface RecorderFunction<T> {
        public PayloadRecorder.Result record(PayloadRecorder var1, String var2, T var3, Consumer<CpioArchiveEntry> var4) throws IOException;
    }
}

