/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.setup.web;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.eclipse.packagedrone.mail.MailService;
import org.eclipse.packagedrone.repo.manage.setup.web.StorageConfiguration;
import org.eclipse.packagedrone.repo.manage.setup.web.internal.Activator;
import org.eclipse.packagedrone.sec.web.controller.HttpConstraints;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.form.FormData;
import org.eclipse.scada.utils.ExceptionHelper;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Controller
@RequestMapping(value={"/config"})
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"ADMIN"})
public class ConfigController
implements InterfaceExtender {
    private static final String SYSPROP_STORAGE_BASE = "drone.storage.base";
    private static final String PID_STORAGE_MANAGER = "drone.storage.manager";
    private static final LinkTarget.ControllerMethod METHOD_MAIN = LinkTarget.getControllerMethod(ConfigController.class, (String)"config");
    private ConfigurationAdmin configurationAdmin;

    public void setConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configurationAdmin = configAdmin;
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (HttpConstraints.isCallAllowed((LinkTarget.ControllerMethod)METHOD_MAIN, (HttpServletRequest)request)) {
            result.add(new MenuEntry("Administration", 10000, "Storage Setup", 100, LinkTarget.createFromController((LinkTarget.ControllerMethod)METHOD_MAIN), Modifier.DEFAULT, null, false, 0L));
        }
        return result;
    }

    private void fillData(Map<String, Object> model) {
        model.put("sysProp", System.getProperty(SYSPROP_STORAGE_BASE));
        model.put("freeSpacePercent", this.freeSpace());
    }

    private Double freeSpace() {
        try {
            String base = System.getProperty(SYSPROP_STORAGE_BASE);
            Path p = Paths.get(base, new String[0]);
            FileStore store = Files.getFileStore(p);
            return (double)store.getUnallocatedSpace() / (double)store.getTotalSpace();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @RequestMapping
    public ModelAndView config() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        StorageConfiguration command = new StorageConfiguration();
        try {
            Configuration cfg = this.configurationAdmin.getConfiguration(PID_STORAGE_MANAGER, null);
            if (cfg != null && cfg.getProperties() != null) {
                command.setBasePath((String)cfg.getProperties().get("basePath"));
            }
        }
        catch (Exception exception) {}
        model.put("command", command);
        this.fillData(model);
        return new ModelAndView("/config/index", model);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView configPost(@Valid @FormData(value="command") StorageConfiguration data, BindingResult result) {
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("command", data);
        this.fillData(model);
        if (!result.hasErrors()) {
            try {
                if (this.applyConfiguration(data.getBasePath())) {
                    try {
                        Activator.getTracker().waitForService(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException e) {
                model.put("error", ExceptionHelper.getMessage((Throwable)e));
            }
        }
        if (this.isMailServicePresent() || result.hasErrors()) {
            return new ModelAndView("/config/index", model);
        }
        return new ModelAndView("redirect:/setup");
    }

    private boolean applyConfiguration(String basePath) throws IOException {
        Configuration cfg = this.configurationAdmin.getConfiguration(PID_STORAGE_MANAGER, null);
        if (basePath == null || basePath.isEmpty()) {
            cfg.update(new Hashtable());
            return false;
        }
        Hashtable<String, String> data = new Hashtable<String, String>();
        ((Dictionary)data).put("basePath", basePath);
        cfg.update(data);
        return true;
    }

    protected boolean isMailServicePresent() {
        return FrameworkUtil.getBundle(ConfigController.class).getBundleContext().getServiceReference(MailService.class) != null;
    }
}

