/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger.common.unique;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.VetoPolicy;
import org.eclipse.packagedrone.repo.gson.MetaKeyTypeAdapter;

public class UniqueArtifactConfiguration {
    private static final VetoPolicy DEFAULT_VETO_POLICY = VetoPolicy.REJECT;
    @Size(min=1, message="Field must not be empty")
    private MetaKey[] keys = new MetaKey[0];
    @NotNull(message="Field must not be empty")
    private MetaKey uniqueAttribute;
    private VetoPolicy vetoPolicy = DEFAULT_VETO_POLICY;
    private String reason;
    private boolean skipMissingAttributes = true;

    public void setKeys(MetaKey[] keys) {
        this.keys = keys;
    }

    public MetaKey[] getKeys() {
        return this.keys;
    }

    public void setUniqueAttribute(MetaKey uniqueAttribute) {
        this.uniqueAttribute = uniqueAttribute;
    }

    public MetaKey getUniqueAttribute() {
        return this.uniqueAttribute;
    }

    public void setVetoPolicy(VetoPolicy vetoPolicy) {
        this.vetoPolicy = vetoPolicy != null ? vetoPolicy : DEFAULT_VETO_POLICY;
    }

    public VetoPolicy getVetoPolicy() {
        return this.vetoPolicy;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReason() {
        return this.reason;
    }

    public void setSkipMissingAttributes(boolean skipMissingAttributes) {
        this.skipMissingAttributes = skipMissingAttributes;
    }

    public boolean isSkipMissingAttributes() {
        return this.skipMissingAttributes;
    }

    private static Gson createGson() {
        return new GsonBuilder().registerTypeAdapter(MetaKey.class, (Object)MetaKeyTypeAdapter.INSTANCE).create();
    }

    public static UniqueArtifactConfiguration fromJson(String json) {
        if (json == null) {
            return null;
        }
        return (UniqueArtifactConfiguration)UniqueArtifactConfiguration.createGson().fromJson(json, UniqueArtifactConfiguration.class);
    }

    public String toJson() {
        return UniqueArtifactConfiguration.createGson().toJson((Object)this);
    }
}

