/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.service.common.internal;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.utils.Splits;
import org.eclipse.packagedrone.sec.UserInformation;
import org.eclipse.packagedrone.sec.service.AccessToken;
import org.eclipse.packagedrone.sec.service.AccessTokenService;
import org.eclipse.packagedrone.sec.service.LoginException;
import org.eclipse.packagedrone.sec.service.SecurityService;
import org.eclipse.packagedrone.sec.service.UserService;
import org.eclipse.packagedrone.sec.service.common.AccessTokenPrincipal;
import org.eclipse.packagedrone.sec.service.common.internal.AccessTokenStorage;
import org.eclipse.packagedrone.sec.service.common.internal.AccessTokenStorageHandler;
import org.eclipse.packagedrone.sec.service.common.internal.ModifiableAccessTokenStorage;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.packagedrone.storage.apm.StorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageRegistration;
import org.eclipse.scada.utils.ExceptionHelper;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityServiceImpl
implements SecurityService,
AccessTokenService {
    private static final Logger logger = LoggerFactory.getLogger(SecurityServiceImpl.class);
    private static final MetaKey MODEL_KEY = new MetaKey("core", "security");
    private StorageManager storageManager;
    private final ServiceTracker<UserService, UserService> userServiceTracker = new ServiceTracker(FrameworkUtil.getBundle(SecurityServiceImpl.class).getBundleContext(), UserService.class, null);
    private StorageRegistration modelHandle;

    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    public void activate() {
        this.userServiceTracker.open();
        this.modelHandle = this.storageManager.registerModel(1000L, MODEL_KEY, (StorageModelProvider)new AccessTokenStorageHandler());
    }

    public void deactivate() {
        if (this.modelHandle != null) {
            this.modelHandle.unregister();
            this.modelHandle = null;
        }
        this.userServiceTracker.close();
    }

    public UserInformation login(String username, String password) throws LoginException {
        return this.login(username, password, false);
    }

    public UserInformation login(String username, String password, boolean rememberMe) throws LoginException {
        Collection services = this.userServiceTracker.getTracked().values();
        if (services == null || services.isEmpty()) {
            throw new LoginException("No login service available");
        }
        for (UserService service : services) {
            try {
                UserInformation user = service.checkCredentials(username, password, rememberMe);
                if (user == null) continue;
                return user;
            }
            catch (Exception e) {
                if (ExceptionHelper.getRootCause((Throwable)e) instanceof LoginException) {
                    throw e;
                }
                logger.warn("UserService failed", (Throwable)e);
            }
        }
        throw new LoginException("Login error!", "Invalid username or password.");
    }

    public Optional<Principal> accessByToken(String token) {
        Optional accessToken = (Optional)this.storageManager.accessCall(MODEL_KEY, AccessTokenStorage.class, storage -> storage.getByToken(token));
        return accessToken.map(value -> new AccessTokenPrincipal(value.getId(), Arrays.asList("MANAGER")));
    }

    public List<AccessToken> list(int start, int amount) {
        return (List)this.storageManager.accessCall(MODEL_KEY, AccessTokenStorage.class, storage -> Splits.split(storage.list(), (int)start, (int)amount));
    }

    public AccessToken createAccessToken(String description) {
        return (AccessToken)this.storageManager.modifyCall(MODEL_KEY, ModifiableAccessTokenStorage.class, storage -> storage.createAccessToken(description));
    }

    public void editAccessToken(String id, String description) {
        this.storageManager.modifyRun(MODEL_KEY, ModifiableAccessTokenStorage.class, storage -> storage.editAccessToken(id, description));
    }

    public Optional<AccessToken> getToken(String id) {
        return (Optional)this.storageManager.accessCall(MODEL_KEY, AccessTokenStorage.class, storage -> storage.getToken(id));
    }

    public void deleteAccessToken(String id) {
        this.storageManager.modifyRun(MODEL_KEY, ModifiableAccessTokenStorage.class, storage -> storage.deleteAccessToken(id));
    }

    public boolean hasUserBase() {
        Collection services = this.userServiceTracker.getTracked().values();
        for (UserService service : services) {
            if (!service.hasUserBase()) continue;
            return true;
        }
        return false;
    }

    public UserInformation refresh(UserInformation user) {
        Collection services = this.userServiceTracker.getTracked().values();
        if (services == null || services.isEmpty()) {
            return user;
        }
        for (UserService service : services) {
            UserInformation refreshedUser = service.refresh(user);
            if (refreshedUser == null) continue;
            return refreshedUser;
        }
        return user;
    }
}

