/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.lifecycle;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ops4j.pax.swissbox.lifecycle.Lifecycle;

public abstract class AbstractLifecycle
implements Lifecycle {
    private static final State STARTED = new Started();
    private static final State STOPPED = new Stopped();
    private final Lock m_lock = new ReentrantLock();
    private State m_state = STOPPED;

    protected AbstractLifecycle() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        try {
            this.m_lock.lock();
            if (STARTED != this.m_state) {
                this.m_state.start(this);
                this.m_state = STARTED;
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            this.m_lock.lock();
            if (STOPPED != this.m_state) {
                this.m_state.stop(this);
                this.m_state = STOPPED;
            }
        }
        finally {
            this.m_lock.unlock();
        }
    }

    @Override
    public boolean isStarted() {
        return this.m_state == STARTED;
    }

    protected abstract void onStart();

    protected abstract void onStop();

    private static class Stopped
    extends State {
        private Stopped() {
        }

        @Override
        public void start(AbstractLifecycle context) {
            context.onStart();
        }
    }

    private static class Started
    extends State {
        private Started() {
        }

        @Override
        public void stop(AbstractLifecycle context) {
            context.onStop();
        }
    }

    private static class State {
        private State() {
        }

        public void start(AbstractLifecycle context) {
        }

        public void stop(AbstractLifecycle context) {
        }
    }
}

