/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.maven.internal;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.packagedrone.repo.aspect.extract.Extractor;
import org.eclipse.packagedrone.repo.xml.XmlFiles;
import org.eclipse.packagedrone.repo.xml.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MavenInformationExtractor
implements Extractor {
    private static final String NS = "http://maven.apache.org/POM/4.0.0";
    private final XmlHelper xml = new XmlHelper();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractMetaData(Extractor.Context context, Map<String, String> metadata) throws Exception {
        if (!XmlFiles.isXml((Path)context.getPath())) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(context.getPath().toFile()));
                try {
                    Document doc = this.xml.parse((InputStream)in);
                    Element root = doc.getDocumentElement();
                    if (!root.getNodeName().equals("project")) {
                        return;
                    }
                    String ns = root.getNamespaceURI();
                    if (ns != null && !ns.equals(NS)) {
                        context.validationInformation("Ignoring POM file: The namespace set but is not: http://maven.apache.org/POM/4.0.0");
                        return;
                    }
                    String groupId = this.xml.getElementValue((Node)root, "./groupId");
                    if (groupId == null) {
                        groupId = this.xml.getElementValue((Node)root, "./parent/groupId");
                    }
                    String artifactId = this.xml.getElementValue((Node)root, "./artifactId");
                    String version = this.xml.getElementValue((Node)root, "./version");
                    if (version == null) {
                        version = this.xml.getElementValue((Node)root, "./parent/version");
                    }
                    if (groupId == null || groupId.isEmpty()) {
                        context.validationInformation("Ignoring POM file: There is no group id");
                        return;
                    }
                    if (artifactId == null || artifactId.isEmpty()) {
                        context.validationInformation("Ignoring POM file: There is no artifact id");
                        return;
                    }
                    if (version == null || version.isEmpty()) {
                        context.validationInformation("Ignoring POM file: There is no version");
                        return;
                    }
                    metadata.put("groupId", groupId);
                    metadata.put("artifactId", artifactId);
                    metadata.put("version", version);
                    metadata.put("extension", "pom");
                    return;
                }
                finally {
                    if (in == null) return;
                    in.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }
}

