/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.internal.servlet;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;

public final class MavenLocator {
    public static final MetaKey KEY_GROUP_ID = new MetaKey("mvn", "groupId");
    public static final MetaKey KEY_ARTIFACT_ID = new MetaKey("mvn", "artifactId");
    public static final MetaKey KEY_VERSION = new MetaKey("mvn", "version");
    public static final MetaKey KEY_SNAPSHOT_VERSION = new MetaKey("mvn", "snapshotVersion");
    public static final MetaKey KEY_EXTENSION = new MetaKey("mvn", "extension");
    public static final MetaKey KEY_CLASSIFIER = new MetaKey("mvn", "classifier");

    private MavenLocator() {
    }

    public static List<ArtifactInformation> findByMavenCoordinates(Collection<ArtifactInformation> artifacts, String groupId, String artifactId, String version, String snapshotVersion, String extension, String classifier) {
        Stream<ArtifactInformation> s = MavenLocator.filterByCoordinates(artifacts.stream(), groupId, artifactId, version, snapshotVersion, extension, classifier);
        return s.collect(Collectors.toList());
    }

    public static <T extends ArtifactInformation> Stream<T> filterByCoordinates(Stream<T> s, String groupId, String artifactId, String version, String snapshotVersion, String extension, String classifier) {
        s = s.filter(art -> MavenLocator.has(art, KEY_GROUP_ID, groupId));
        s = s.filter(art -> MavenLocator.has(art, KEY_ARTIFACT_ID, artifactId));
        s = s.filter(art -> MavenLocator.has(art, KEY_VERSION, version));
        s = s.filter(art -> MavenLocator.has(art, KEY_SNAPSHOT_VERSION, snapshotVersion));
        s = s.filter(art -> MavenLocator.has(art, KEY_EXTENSION, extension));
        s = s.filter(art -> MavenLocator.has(art, KEY_CLASSIFIER, classifier));
        return s;
    }

    private static boolean has(ArtifactInformation art, MetaKey key, String expectedValue) {
        String actualValue = (String)art.getMetaData().get(key);
        if (actualValue == expectedValue) {
            return true;
        }
        if (actualValue == null) {
            return false;
        }
        return actualValue.equals(expectedValue);
    }

    private static String get(ArtifactInformation art, MetaKey key) {
        Objects.requireNonNull(art);
        return (String)art.getMetaData().get(key);
    }

    public static String getGroupId(ArtifactInformation art) {
        return MavenLocator.get(art, KEY_GROUP_ID);
    }

    public static String getArtifactId(ArtifactInformation art) {
        return MavenLocator.get(art, KEY_ARTIFACT_ID);
    }

    public static String getVersion(ArtifactInformation art) {
        return MavenLocator.get(art, KEY_VERSION);
    }

    public static String getSnapshotVersion(ArtifactInformation art) {
        return MavenLocator.get(art, KEY_SNAPSHOT_VERSION);
    }

    public static String getExtension(ArtifactInformation art) {
        return MavenLocator.get(art, KEY_EXTENSION);
    }

    public static String getClassifier(ArtifactInformation art) {
        return MavenLocator.get(art, KEY_CLASSIFIER);
    }
}

