/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.web.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import org.eclipse.packagedrone.repo.channel.web.breadcrumbs.Breadcrumbs;
import org.eclipse.packagedrone.sec.CreateUser;
import org.eclipse.packagedrone.sec.DatabaseDetails;
import org.eclipse.packagedrone.sec.DatabaseUserInformation;
import org.eclipse.packagedrone.sec.UserDetails;
import org.eclipse.packagedrone.sec.UserStorage;
import org.eclipse.packagedrone.sec.web.controller.HttpConstraints;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.sec.web.filter.SecurityFilter;
import org.eclipse.packagedrone.sec.web.ui.AbstractUserCreationController;
import org.eclipse.packagedrone.sec.web.ui.NewPassword;
import org.eclipse.packagedrone.sec.web.ui.UserDetailsBean;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.common.page.Pagination;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.packagedrone.web.controller.form.FormData;

@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@RequestMapping(value={"/user"})
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"ADMIN"})
public class UserController
extends AbstractUserCreationController
implements InterfaceExtender {
    private static final LinkTarget.ControllerMethod METHOD_LIST = LinkTarget.getControllerMethod(UserController.class, (String)"list");
    private static final LinkTarget.ControllerMethod METHOD_ADD_USER = LinkTarget.getControllerMethod(UserController.class, (String)"addUser");

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (HttpConstraints.isCallAllowed((LinkTarget.ControllerMethod)METHOD_LIST, (HttpServletRequest)request)) {
            result.add(new MenuEntry("Administration", 10000, "Users", 1000, LinkTarget.createFromController((LinkTarget.ControllerMethod)METHOD_LIST), null, null));
        }
        return result;
    }

    public List<MenuEntry> getActions(HttpServletRequest request, Object object) {
        DatabaseDetails details;
        if (UserStorage.ACTION_TAG_USERS.equals(object)) {
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            if (HttpConstraints.isCallAllowed((LinkTarget.ControllerMethod)METHOD_ADD_USER, (HttpServletRequest)request)) {
                result.add(new MenuEntry("Add user", 100, LinkTarget.createFromController((LinkTarget.ControllerMethod)METHOD_ADD_USER), Modifier.PRIMARY, null));
            }
            return result;
        }
        if (object instanceof DatabaseUserInformation && (details = (DatabaseDetails)((DatabaseUserInformation)object).getDetails(DatabaseDetails.class)) != null) {
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            HashMap<String, String> model = new HashMap<String, String>(1);
            String userId = ((DatabaseUserInformation)object).getId();
            model.put("userId", userId);
            boolean you = this.isYou(userId, request);
            if (HttpConstraints.isCallAllowed((LinkTarget.ControllerMethod)METHOD_ADD_USER, (HttpServletRequest)request)) {
                result.add(new MenuEntry("Edit user", 100, LinkTarget.createFromController(UserController.class, (String)"editUser").expand(model), Modifier.PRIMARY, null));
                if (!you) {
                    if (details.isLocked()) {
                        result.add(new MenuEntry("Unlock user", 200, LinkTarget.createFromController(UserController.class, (String)"unlockUser").expand(model), Modifier.SUCCESS, null));
                    } else {
                        result.add(new MenuEntry("Lock user", 200, LinkTarget.createFromController(UserController.class, (String)"lockUser").expand(model), Modifier.WARNING, null).makeModalMessage("Lock user", "This will prevent the user from logging in. It can be reveresed by unlocking the user."));
                    }
                    if (!details.isDeleted()) {
                        result.add(new MenuEntry("Delete user", 300, LinkTarget.createFromController(UserController.class, (String)"deleteUser").expand(model), Modifier.DANGER, "trash").makeModalMessage("Delete user", "Are you sure you want to delete this user?"));
                    }
                }
            }
            return result;
        }
        return null;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView list(@RequestParameter(required=false, value="start") Integer position) {
        ModelAndView result = new ModelAndView("user/list");
        result.put("users", (Object)Pagination.paginate((Integer)position, (int)25, (arg_0, arg_1) -> ((UserStorage)this.storage).list(arg_0, arg_1)));
        return result;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public ModelAndView addUser() {
        ModelAndView model = new ModelAndView("user/add");
        model.put("command", (Object)new CreateUser());
        return model;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ModelAndView addUserPost(@Valid @FormData(value="command") CreateUser data, BindingResult result) {
        if (result.hasErrors()) {
            HashMap<String, CreateUser> model = new HashMap<String, CreateUser>(1);
            model.put("command", data);
            return new ModelAndView("user/add", model);
        }
        DatabaseUserInformation newUser = this.storage.createUser(data, true);
        return new ModelAndView(String.format("redirect:/user/%s/view", newUser.getId()));
    }

    @RequestMapping(value={"/{userId}/view"}, method={RequestMethod.GET})
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView viewUser(@PathVariable(value="userId") String userId, HttpServletRequest request) {
        boolean you = this.isYou(userId, request);
        if (!you && !request.isUserInRole("ADMIN")) {
            return CommonController.createAccessDenied();
        }
        DatabaseUserInformation user = this.storage.getUserDetails(userId);
        if (user == null || user.getDetails(DatabaseDetails.class) == null) {
            return CommonController.createNotFound((String)"user", (String)userId);
        }
        ModelAndView model = new ModelAndView("user/view");
        model.put("user", (Object)user);
        model.put("you", (Object)you);
        return model;
    }

    protected boolean isYou(String userId, HttpServletRequest request) {
        return userId.equals(request.getRemoteUser());
    }

    protected void addBreadcrumbs(String action, String userId, Map<String, Object> model) {
        model.put("breadcrumbs", new Breadcrumbs(new Breadcrumbs.Entry[]{new Breadcrumbs.Entry("Home", "/"), Breadcrumbs.create((String)"Users", UserController.class, (String)"list"), Breadcrumbs.create((String)"User", UserController.class, (String)"viewUser", (String)"userId", (Object)userId), new Breadcrumbs.Entry(action)}));
    }

    @RequestMapping(value={"/{userId}/edit"}, method={RequestMethod.GET})
    public ModelAndView editUser(@PathVariable(value="userId") String userId) {
        DatabaseUserInformation user = this.storage.getUserDetails(userId);
        if (user == null || user.getDetails(DatabaseDetails.class) == null) {
            return CommonController.createNotFound((String)"user", (String)userId);
        }
        HashMap<String, Object> model = new HashMap<String, Object>(2);
        model.put("user", user);
        DatabaseDetails details = (DatabaseDetails)user.getDetails(DatabaseDetails.class);
        UserDetailsBean bean = new UserDetailsBean();
        bean.setEmail(details.getEmail());
        bean.setName(details.getName());
        bean.setRoles(new HashSet<String>(details.getRoles()));
        model.put("command", bean);
        model.put("allRoles", this.makePossibleRoles(details.getRoles()));
        this.addBreadcrumbs("Edit", userId, model);
        return new ModelAndView("user/edit", model);
    }

    private SortedSet<String> makePossibleRoles(Set<String> roles) {
        if (roles == null) {
            return null;
        }
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(roles);
        result.add("MANAGER");
        result.add("ADMIN");
        return result;
    }

    @RequestMapping(value={"/{userId}/edit"}, method={RequestMethod.POST})
    public ModelAndView editUserPost(@PathVariable(value="userId") String userId, @Valid @FormData(value="command") UserDetailsBean data, BindingResult result, HttpSession session) {
        DatabaseUserInformation user = this.storage.getUserDetails(userId);
        if (user == null || user.getDetails(DatabaseDetails.class) == null) {
            return CommonController.createNotFound((String)"user", (String)userId);
        }
        if (result.hasErrors()) {
            HashMap<String, Object> model = new HashMap<String, Object>(2);
            model.put("command", data);
            model.put("user", user);
            model.put("allRoles", this.makePossibleRoles(data.getRoles()));
            this.addBreadcrumbs("Edit", userId, model);
            return new ModelAndView("user/edit", model);
        }
        this.storage.updateUser(userId, new UserDetails(data.getName(), data.getEmail(), data.getRoles()));
        SecurityFilter.markReloadDetails((HttpSession)session);
        return new ModelAndView(String.format("redirect:/user/%s/view", userId));
    }

    @RequestMapping(value={"/{userId}/lock"})
    public ModelAndView lockUser(@PathVariable(value="userId") String userId) {
        this.storage.lockUser(userId);
        return new ModelAndView("redirect:/user/" + userId + "/view");
    }

    @RequestMapping(value={"/{userId}/unlock"})
    public ModelAndView unlockUser(@PathVariable(value="userId") String userId) {
        this.storage.unlockUser(userId);
        return new ModelAndView("redirect:/user/" + userId + "/view");
    }

    @RequestMapping(value={"/{userId}/delete"})
    public ModelAndView deleteUser(@PathVariable(value="userId") String userId) {
        this.storage.deleteUser(userId);
        return new ModelAndView("redirect:/user");
    }

    @RequestMapping(value={"/{userId}/newPassword"})
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView changePassword(@PathVariable(value="userId") String userId, HttpServletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        boolean you = this.isYou(userId, request);
        if (!you && !request.isUserInRole("ADMIN")) {
            return CommonController.createAccessDenied();
        }
        DatabaseUserInformation user = this.storage.getUserDetails(userId);
        if (user == null) {
            return CommonController.createNotFound((String)"user", (String)userId);
        }
        DatabaseDetails details = (DatabaseDetails)user.getDetails(DatabaseDetails.class);
        if (details == null) {
            return CommonController.createNotFound((String)"details", (String)userId);
        }
        NewPassword data = new NewPassword();
        data.setEmail(details.getEmail());
        model.put("you", you);
        model.put("command", data);
        return new ModelAndView("user/newPassword", model);
    }

    @RequestMapping(value={"/{userId}/newPassword"}, method={RequestMethod.POST})
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView changePasswordPost(@PathVariable(value="userId") String userId, @Valid @FormData(value="command") NewPassword data, BindingResult result, HttpServletRequest request) {
        boolean you = this.isYou(userId, request);
        if (!you && !request.isUserInRole("ADMIN")) {
            return CommonController.createAccessDenied();
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("you", you);
        if (result.hasErrors()) {
            model.put("command", data);
            return new ModelAndView("user/newPassword", model);
        }
        try {
            if (!you) {
                this.storage.updatePassword(userId, null, data.getPassword());
            } else {
                this.storage.updatePassword(userId, data.getCurrentPassword(), data.getPassword());
            }
            return new ModelAndView("redirect:/user/" + userId + "/view");
        }
        catch (Exception e) {
            return CommonController.createError((String)"Error", (String)"Failed to change password", (Throwable)e);
        }
    }
}

