/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.rpm.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.eclipse.packagedrone.repo.adapter.rpm.Constants;
import org.eclipse.packagedrone.repo.adapter.rpm.RpmInformation;
import org.eclipse.packagedrone.repo.aspect.extract.Extractor;
import org.eclipse.packagedrone.utils.rpm.RpmBaseTag;
import org.eclipse.packagedrone.utils.rpm.RpmSignatureTag;
import org.eclipse.packagedrone.utils.rpm.RpmTag;
import org.eclipse.packagedrone.utils.rpm.parse.InputHeader;
import org.eclipse.packagedrone.utils.rpm.parse.RpmInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpmExtractor
implements Extractor {
    private static final Logger logger = LoggerFactory.getLogger(RpmExtractor.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractMetaData(Extractor.Context context, Map<String, String> metadata) {
        Path path = context.getPath();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                RpmInputStream in = new RpmInputStream((InputStream)new BufferedInputStream(Files.newInputStream(path, StandardOpenOption.READ)));
                try {
                    RpmInformation info = this.makeInformation(in);
                    if (info == null) {
                        return;
                    }
                    metadata.put("artifactLabel", "RPM Package");
                    metadata.put("name", RpmExtractor.asString(in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.NAME)));
                    metadata.put("version", RpmExtractor.asString(in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.VERSION)));
                    metadata.put("os", RpmExtractor.asString(in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.OS)));
                    metadata.put("arch", RpmExtractor.asString(in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.ARCH)));
                    metadata.put(Constants.KEY_INFO.getKey(), info.toJson());
                    return;
                }
                finally {
                    if (in == null) return;
                    in.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    private RpmInformation makeInformation(RpmInputStream in) throws IOException {
        InputHeader header = in.getPayloadHeader();
        InputHeader signature = in.getSignatureHeader();
        try {
            CpioArchiveEntry cpioEntry;
            RpmInformation result = new RpmInformation();
            result.setHeaderStart(header.getStart());
            result.setHeaderEnd(header.getStart() + header.getLength());
            result.setName(RpmExtractor.asString(header.getTag((RpmBaseTag)RpmTag.NAME)));
            result.setArchitecture(RpmExtractor.asString(header.getTag((RpmBaseTag)RpmTag.ARCH)));
            result.setSummary(RpmExtractor.asString(header.getTag((RpmBaseTag)RpmTag.SUMMARY)));
            result.setDescription(RpmExtractor.asString(header.getTag((RpmBaseTag)RpmTag.DESCRIPTION)));
            result.setPackager(RpmExtractor.asString(header.getTag((RpmBaseTag)RpmTag.PACKAGER)));
            result.setUrl(RpmExtractor.asString(header.getTag((RpmBaseTag)RpmTag.URL)));
            result.setLicense(RpmExtractor.asString(header.getTag((RpmBaseTag)RpmTag.LICENSE)));
            result.setVendor(RpmExtractor.asString(header.getTag((RpmBaseTag)RpmTag.VENDOR)));
            result.setGroup(RpmExtractor.asString(header.getTag((RpmBaseTag)RpmTag.GROUP)));
            result.setBuildHost(RpmExtractor.asString(header.getTag((RpmBaseTag)RpmTag.BUILDHOST)));
            result.setBuildTimestamp(RpmExtractor.asLong(header.getTag((RpmBaseTag)RpmTag.BUILDTIME)));
            result.setSourcePackage(RpmExtractor.asString(header.getTag((RpmBaseTag)RpmTag.SOURCE_PACKAGE)));
            result.setInstalledSize(RpmExtractor.asLong(header.getTag((RpmBaseTag)RpmTag.SIZE)));
            result.setArchiveSize(RpmExtractor.asLong(header.getTag((RpmBaseTag)RpmTag.ARCHIVE_SIZE)));
            if (result.getArchiveSize() == null) {
                result.setArchiveSize(RpmExtractor.asLong(signature.getTag((RpmBaseTag)RpmSignatureTag.PAYLOAD_SIZE)));
            }
            RpmInformation.Version ver = new RpmInformation.Version(RpmExtractor.asString(header.getTag((RpmBaseTag)RpmTag.VERSION)), RpmExtractor.asString(header.getTag((RpmBaseTag)RpmTag.RELEASE)), RpmExtractor.asString(header.getTag((RpmBaseTag)RpmTag.EPOCH)));
            result.setVersion(ver);
            Object val = header.getTag((RpmBaseTag)RpmTag.CHANGELOG_TIMESTAMP);
            if (val instanceof Long[]) {
                Long[] ts = (Long[])val;
                String[] authors = (String[])header.getTag((RpmBaseTag)RpmTag.CHANGELOG_AUTHOR);
                String[] texts = (String[])header.getTag((RpmBaseTag)RpmTag.CHANGELOG_TEXT);
                ArrayList<RpmInformation.Changelog> changes = new ArrayList<RpmInformation.Changelog>(ts.length);
                int i = 0;
                while (i < ts.length) {
                    changes.add(new RpmInformation.Changelog(ts[i], authors[i], texts[i]));
                    ++i;
                }
                Collections.sort(changes, (o1, o2) -> Long.compare(o1.getTimestamp(), o2.getTimestamp()));
                result.setChangelog(changes);
            }
            result.setProvides(this.makeDependencies((InputHeader<RpmTag>)header, RpmTag.PROVIDE_NAME, RpmTag.PROVIDE_VERSION, RpmTag.PROVIDE_FLAGS));
            result.setRequires(this.makeDependencies((InputHeader<RpmTag>)header, RpmTag.REQUIRE_NAME, RpmTag.REQUIRE_VERSION, RpmTag.REQUIRE_FLAGS));
            result.setConflicts(this.makeDependencies((InputHeader<RpmTag>)header, RpmTag.CONFLICT_NAME, RpmTag.CONFLICT_VERSION, RpmTag.CONFLICT_FLAGS));
            result.setObsoletes(this.makeDependencies((InputHeader<RpmTag>)header, RpmTag.OBSOLETE_NAME, RpmTag.OBSOLETE_VERSION, RpmTag.OBSOLETE_FLAGS));
            CpioArchiveInputStream cpio = in.getCpioStream();
            while ((cpioEntry = cpio.getNextCPIOEntry()) != null) {
                String name = RpmExtractor.normalize(cpioEntry.getName());
                if (cpioEntry.isRegularFile()) {
                    result.getFiles().add(name);
                    continue;
                }
                if (!cpioEntry.isDirectory()) continue;
                result.getDirectories().add(name);
            }
            cpio.close();
            return result;
        }
        catch (Exception e) {
            logger.info("Failed to create RPM information", (Throwable)e);
            return null;
        }
    }

    private List<RpmInformation.Dependency> makeDependencies(InputHeader<RpmTag> header, RpmTag namesTag, RpmTag versionsTag, RpmTag flagsTag) {
        String[] namesVal = header.getTag((RpmBaseTag)namesTag);
        String[] versionsVal = header.getTag((RpmBaseTag)versionsTag);
        Long[] flagsVal = header.getTag((RpmBaseTag)flagsTag);
        if (namesVal == null || !(namesVal instanceof String[])) {
            if (namesVal instanceof String) {
                namesVal = new String[]{(String)namesVal};
            } else {
                return Collections.emptyList();
            }
        }
        if (versionsVal != null && !(versionsVal instanceof String[])) {
            if (versionsVal instanceof String) {
                versionsVal = new String[]{(String)versionsVal};
            } else {
                throw new IllegalStateException(String.format("Invalid dependencies version format [%s]: %s", versionsTag, versionsVal));
            }
        }
        if (flagsVal != null && !(flagsVal instanceof Long[])) {
            if (flagsVal instanceof Long) {
                flagsVal = new Long[]{(Long)flagsVal};
            } else {
                throw new IllegalStateException(String.format("Invalid dependencies flags format [%s]: %s", flagsTag, flagsVal));
            }
        }
        String[] names = namesVal;
        String[] versions = versionsVal;
        Long[] flags = flagsVal;
        if (versions != null && names.length != versions.length) {
            throw new IllegalStateException(String.format("Invalid size of dependency versions array [%s] - expected: %s, actual: %s", versionsTag, names.length, versions.length));
        }
        if (flags != null && names.length != flags.length) {
            throw new IllegalStateException(String.format("Invalid size of dependency flags array [%s] - expected: %s, actual: %s", flagsTag, names.length, flags.length));
        }
        ArrayList<RpmInformation.Dependency> result = new ArrayList<RpmInformation.Dependency>(names.length);
        HashSet<String> known = new HashSet<String>();
        int i = 0;
        while (i < names.length) {
            String version;
            String name = names[i];
            String string = version = versions != null ? versions[i] : null;
            if (version != null && version.isEmpty()) {
                version = null;
            }
            Long flag = flags != null ? flags[i] : null;
            String key = name;
            if (known.add(key)) {
                result.add(new RpmInformation.Dependency(name, version, flag != null ? flag : 0L));
            }
            ++i;
        }
        return result;
    }

    private static String normalize(String name) {
        if (name.startsWith("./")) {
            return name.substring(1);
        }
        return name;
    }

    private static String asString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    private static Long asLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        try {
            return Long.parseLong(value.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

