/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl.transfer;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.packagedrone.VersionInformation;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.XmlHelper;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelDetails;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.DescriptorAdapter;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.impl.transfer.TriggerExport;
import org.eclipse.packagedrone.repo.channel.transfer.ImportOptions;
import org.eclipse.packagedrone.repo.channel.transfer.TransferService;
import org.eclipse.packagedrone.repo.trigger.TriggeredChannel;
import org.eclipse.packagedrone.utils.xml.XmlToolsFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransferServiceImpl
implements TransferService {
    private ChannelService channelService;
    private XmlToolsFactory xmlToolsFactory;

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setXmlToolsFactory(XmlToolsFactory xmlToolsFactory) {
        this.xmlToolsFactory = xmlToolsFactory;
    }

    public void importAll(InputStream inputStream, ImportOptions options, boolean wipe) throws IOException {
        ZipEntry ze;
        if (wipe) {
            this.channelService.wipeClean();
        }
        ZipInputStream zis = new ZipInputStream(inputStream);
        while ((ze = zis.getNextEntry()) != null) {
            String name;
            if (ze.isDirectory() || !(name = ze.getName()).endsWith(".zip")) continue;
            this.importChannel(zis, options);
        }
    }

    public ChannelId importChannel(InputStream inputStream, ImportOptions options) throws IOException {
        Path tmp = Files.createTempFile("imp", null, new FileAttribute[0]);
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedOutputStream tmpStream = new BufferedOutputStream(new FileOutputStream(tmp.toFile()));){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)tmpStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ChannelId channelId = this.processImport(tmp, options);
            return channelId;
        }
        finally {
            Files.deleteIfExists(tmp);
        }
    }

    private ChannelId processImport(Path tmp, ImportOptions options) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipFile zip = new ZipFile(tmp.toFile());){
            String version = this.getData(zip, "version");
            if (!"1".equals(version)) {
                throw new IllegalArgumentException(String.format("Version '%s' is not supported", version));
            }
            String name = this.getData(zip, "name");
            Set<String> names = this.parseNames(this.getData(zip, "names"));
            if (name != null) {
                names.add(name);
            }
            String description = this.getData(zip, "description");
            Map<MetaKey, String> properties = this.getProperties(zip, "properties.xml");
            Set<String> aspects = this.getAspects(zip);
            ChannelDetails details = new ChannelDetails();
            details.setDescription(description);
            ChannelId channelId = this.channelService.create("apm", details, Collections.emptyMap());
            ChannelService.By by = ChannelService.By.id((String)channelId.getId());
            if (options.isUseNames() && !names.isEmpty()) {
                this.channelService.accessRun(by, DescriptorAdapter.class, channel -> channel.setNames((Collection)names));
            }
            this.channelService.accessRun(by, ModifiableChannel.class, channel -> {
                if (properties != null && !properties.isEmpty()) {
                    channel.applyMetaData(properties);
                }
                this.processArtifacts((ModifiableChannel)channel, zip);
                if (aspects != null && !aspects.isEmpty()) {
                    channel.getContext().addAspects(aspects);
                }
            });
            String triggers = this.getData(zip, "triggers.json");
            if (triggers != null && options.isProcessTriggers()) {
                TriggerExport triggerExport = TriggerExport.fromJson(triggers);
                this.channelService.accessRun(by, TriggeredChannel.class, channel -> this.importTriggers(triggerExport, (TriggeredChannel)channel));
            }
            return channelId;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void processArtifacts(ModifiableChannel channel, ZipFile zip) throws IOException {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        Entry root = new Entry();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            String name = ze.getName();
            if (!name.startsWith("artifacts/") || !name.endsWith("/data")) continue;
            List<String> segs = Arrays.asList(name.split("\\/"));
            root.addChild(new LinkedList<String>(segs.subList(1, segs.size() - 1)), ze);
        }
        try {
            root.store(zip, channel, Optional.empty());
        }
        catch (Exception e) {
            throw new IOException("Failed to import artifacts", e);
        }
    }

    private Map<MetaKey, String> getProperties(ZipFile zip, String name) throws IOException {
        ZipEntry ze = zip.getEntry(name);
        if (ze == null) {
            return null;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream stream = zip.getInputStream(ze);){
            return this.readProperties(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getData(ZipFile zip, String name) throws IOException {
        ZipEntry ze = zip.getEntry(name);
        if (ze == null) {
            return null;
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader reader = new InputStreamReader(zip.getInputStream(ze), StandardCharsets.UTF_8);){
            return CharStreams.toString((Readable)reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Map<MetaKey, String> readProperties(InputStream stream) throws IOException {
        try {
            Document doc = this.xmlToolsFactory.newDocumentBuilder().parse(new FilterInputStream(stream){

                @Override
                public void close() {
                }
            });
            Element root = doc.getDocumentElement();
            if (!"properties".equals(root.getNodeName())) {
                throw new IllegalStateException(String.format("Root element must be of type '%s'", "properties"));
            }
            HashMap<MetaKey, String> result = new HashMap<MetaKey, String>();
            for (Element ele : XmlHelper.iterElement((Element)root, (String)"property")) {
                String namespace = ele.getAttribute("namespace");
                String key = ele.getAttribute("key");
                String value = ele.getTextContent();
                if (namespace.isEmpty() || key.isEmpty()) continue;
                result.put(new MetaKey(namespace, key), value);
            }
            return result;
        }
        catch (Exception e) {
            throw new IOException("Failed to read properties", e);
        }
    }

    private Set<String> getAspects(ZipFile zip) throws IOException {
        ZipEntry ze = zip.getEntry("aspects");
        if (ze == null) {
            return Collections.emptySet();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream stream = zip.getInputStream(ze);){
            List lines = CharStreams.readLines((Readable)new InputStreamReader(stream, StandardCharsets.UTF_8));
            return new HashSet<String>(lines);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void initExportFile(ZipOutputStream zos) throws IOException {
        this.putDataEntry(zos, "version", "1");
        this.putDataEntry(zos, "droneVersion", VersionInformation.VERSION);
    }

    public void exportAll(OutputStream stream) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(stream);
        this.initExportFile(zos);
        Collection ids = this.channelService.list();
        for (ChannelId channelId : ids) {
            zos.putNextEntry(new ZipEntry(String.format("%s.zip", channelId.getId())));
            this.exportChannel(ChannelService.By.id((String)channelId.getId()), (OutputStream)zos);
            zos.closeEntry();
        }
        zos.finish();
    }

    private void exportChannel(ChannelService.By by, OutputStream stream) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(stream);
        this.initExportFile(zos);
        this.channelService.accessRun(by, ReadableChannel.class, channel -> {
            this.putDataEntry(zos, "names", this.makeNames(channel.getId()));
            this.putDataEntry(zos, "description", channel.getId().getDescription());
            this.putDirEntry(zos, "artifacts");
            this.putProperties(zos, "properties.xml", channel.getContext().getProvidedMetaData());
            this.putAspects(zos, channel.getContext().getAspectStates().keySet());
            this.putArtifacts(zos, "artifacts/", (ReadableChannel)channel, channel.getArtifacts(), true);
        });
        this.channelService.accessRun(by, TriggeredChannel.class, channel -> this.putTriggers(zos, (TriggeredChannel)channel));
        zos.finish();
    }

    private Set<String> parseNames(String data) {
        if (data == null) {
            return new HashSet<String>(1);
        }
        Gson gson = new GsonBuilder().create();
        String[] names = (String[])gson.fromJson(data, String[].class);
        return new HashSet<String>(Arrays.asList(names));
    }

    private String makeNames(ChannelId channelId) {
        Object[] names = channelId.getNames().toArray(new String[channelId.getNames().size()]);
        if (names.length == 0) {
            return null;
        }
        Arrays.sort(names);
        return new GsonBuilder().create().toJson((Object)names);
    }

    public void exportChannel(String channelId, OutputStream stream) throws IOException {
        this.exportChannel(ChannelService.By.id((String)channelId), stream);
    }

    private void putArtifacts(ZipOutputStream zos, String baseName, ReadableChannel channel, Collection<? extends ArtifactInformation> inputArtifacts, boolean onlyRoot) throws IOException {
        ArrayList<? extends ArtifactInformation> artifacts = new ArrayList<ArtifactInformation>(inputArtifacts);
        Collections.sort(artifacts, Comparator.comparing(ArtifactInformation::getId));
        for (ArtifactInformation artifactInformation : artifacts) {
            if (!artifactInformation.is("stored") || onlyRoot && artifactInformation.getParentId() != null) continue;
            String name = String.format("%s%s/", baseName, artifactInformation.getId());
            ZipEntry ze = new ZipEntry(name);
            ze.setComment(artifactInformation.getName());
            FileTime timestamp = FileTime.fromMillis(artifactInformation.getCreationTimestamp().getTime());
            ze.setLastModifiedTime(timestamp);
            ze.setCreationTime(timestamp);
            ze.setLastAccessTime(timestamp);
            zos.putNextEntry(ze);
            zos.closeEntry();
            this.putProperties(zos, String.valueOf(name) + "properties.xml", artifactInformation.getProvidedMetaData());
            this.putDataEntry(zos, String.valueOf(name) + "name", artifactInformation.getName());
            if (artifactInformation.is("generator")) {
                this.putDataEntry(zos, String.valueOf(name) + "generator", artifactInformation.getVirtualizerAspectId());
            }
            try {
                channel.getContext().stream(artifactInformation.getId(), in -> {
                    zos.putNextEntry(new ZipEntry(String.valueOf(name) + "data"));
                    ByteStreams.copy((InputStream)in, (OutputStream)zos);
                    zos.closeEntry();
                });
            }
            catch (Exception e) {
                throw new IOException("Failed to export artifact", e);
            }
            List childs = artifactInformation.getChildIds().stream().map(id -> channel.getArtifact(id)).filter(opt -> opt.isPresent()).map(opt -> (ChannelArtifactInformation)opt.get()).collect(Collectors.toList());
            this.putArtifacts(zos, name, channel, childs, false);
        }
    }

    private void putAspects(ZipOutputStream zos, Set<String> aspects) throws IOException {
        ArrayList<String> list = new ArrayList<String>(aspects);
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        for (String aspect : list) {
            sb.append(aspect).append('\n');
        }
        this.putDataEntry(zos, "aspects", sb.toString());
    }

    private void importTriggers(TriggerExport triggerExport, TriggeredChannel channel) {
        triggerExport.apply(channel);
    }

    private void putTriggers(ZipOutputStream zos, TriggeredChannel channel) throws IOException {
        TriggerExport export = TriggerExport.buildFrom(channel);
        this.putDataEntry(zos, "triggers.json", export.toJson());
    }

    private void putProperties(ZipOutputStream zos, String name, Map<MetaKey, String> providedMetaData) throws IOException {
        if (providedMetaData.isEmpty()) {
            return;
        }
        zos.putNextEntry(new ZipEntry(name));
        XmlHelper xml = new XmlHelper();
        Document doc = xml.create();
        Element root = doc.createElement("properties");
        doc.appendChild(root);
        TreeMap<MetaKey, String> sorted = new TreeMap<MetaKey, String>(providedMetaData);
        for (Map.Entry entry : sorted.entrySet()) {
            Element p = XmlHelper.addElement((Element)root, (String)"property");
            p.setAttribute("namespace", ((MetaKey)entry.getKey()).getNamespace());
            p.setAttribute("key", ((MetaKey)entry.getKey()).getKey());
            p.setTextContent((String)entry.getValue());
        }
        try {
            xml.write((Node)doc, (OutputStream)zos);
            zos.closeEntry();
        }
        catch (Exception e) {
            throw new IOException("Failed to serialize XML", e);
        }
    }

    private void putDirEntry(ZipOutputStream zos, String name) throws IOException {
        if (!name.endsWith("/")) {
            name = String.valueOf(name) + "/";
        }
        ZipEntry entry = new ZipEntry(name);
        zos.putNextEntry(entry);
        zos.closeEntry();
    }

    private void putDataEntry(ZipOutputStream stream, String name, String data) throws IOException {
        if (data == null) {
            return;
        }
        stream.putNextEntry(new ZipEntry(name));
        stream.write(data.getBytes(StandardCharsets.UTF_8));
        stream.closeEntry();
    }

    private class Entry {
        private final Map<String, Entry> children = new HashMap<String, Entry>();
        private ZipEntry zipEntry;
        private final List<String> ids;

        public Entry() {
            this.ids = Collections.emptyList();
        }

        public Entry(List<String> ids) {
            this.ids = ids;
        }

        public void addChild(LinkedList<String> path, ZipEntry zipEntry) {
            String seg = path.pop();
            Entry child = this.children.get(seg);
            if (child == null) {
                ArrayList<String> ids = new ArrayList<String>(this.ids);
                ids.add(seg);
                child = new Entry(ids);
                this.children.put(seg, child);
            }
            if (path.isEmpty()) {
                child.zipEntry = zipEntry;
            } else {
                child.addChild(path, zipEntry);
            }
        }

        public void store(ZipFile zip, ModifiableChannel channel, Optional<ArtifactInformation> parent) throws Exception {
            for (Entry child : this.children.values()) {
                ArtifactInformation result;
                String baseName = String.format("%s%s/", "artifacts/", child.ids.stream().collect(Collectors.joining("/")));
                String name = TransferServiceImpl.this.getData(zip, String.valueOf(baseName) + "name");
                String generatorId = TransferServiceImpl.this.getData(zip, String.valueOf(baseName) + "generator");
                Throwable throwable = null;
                Object var11_12 = null;
                try (InputStream stream = zip.getInputStream(child.zipEntry);){
                    Map providedMetaData = TransferServiceImpl.this.getProperties(zip, String.valueOf(baseName) + "properties.xml");
                    if (generatorId != null) {
                        result = channel.getContext().createGeneratorArtifact(generatorId, stream, name, providedMetaData);
                    } else {
                        String parentId = parent.map(ArtifactInformation::getId).orElse(null);
                        result = channel.getContext().createArtifact(parentId, stream, name, providedMetaData);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (result == null) continue;
                child.store(zip, channel, Optional.of(result));
            }
        }
    }
}

