/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.spifly.weaver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.aries.spifly.Util;
import org.apache.aries.spifly.WeavingData;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class TCCLSetterVisitor
extends ClassVisitor
implements Opcodes {
    private static final Type CLASSLOADER_TYPE = Type.getType(ClassLoader.class);
    private static final String GENERATED_METHOD_NAME = "$$FCCL$$";
    private static final Type UTIL_CLASS = Type.getType(Util.class);
    private static final Type CLASS_TYPE = Type.getType(Class.class);
    private static final Type String_TYPE = Type.getType(String.class);
    private final Type targetClass;
    private final Set<WeavingData> weavingData;
    private boolean additionalImportRequired = false;
    private boolean woven = false;

    public TCCLSetterVisitor(ClassVisitor cv, String className, Set<WeavingData> weavingData) {
        super(262144, cv);
        this.targetClass = Type.getType((String)("L" + className.replace('.', '/') + ";"));
        this.weavingData = weavingData;
    }

    public boolean isWoven() {
        return this.woven;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return new TCCLSetterMethodVisitor(mv, access, name, desc);
    }

    public void visitEnd() {
        if (!this.woven) {
            super.visitEnd();
            return;
        }
        HashSet<String> methodNames = new HashSet<String>();
        for (WeavingData wd : this.weavingData) {
            String methodName = this.getGeneratedMethodName(wd);
            if (methodNames.contains(methodName)) continue;
            methodNames.add(methodName);
            Method method = new Method(methodName, Type.VOID_TYPE, new Type[]{CLASS_TYPE});
            GeneratorAdapter mv = new GeneratorAdapter(this.cv.visitMethod(10, methodName, method.getDescriptor(), null, null), 10, methodName, method.getDescriptor());
            mv.visitLdcInsn((Object)wd.getClassName());
            mv.visitLdcInsn((Object)wd.getMethodName());
            mv.loadArg(0);
            mv.visitLdcInsn((Object)this.targetClass);
            mv.invokeVirtual(CLASS_TYPE, new Method("getClassLoader", CLASSLOADER_TYPE, new Type[0]));
            mv.invokeStatic(UTIL_CLASS, new Method("fixContextClassloader", Type.VOID_TYPE, new Type[]{String_TYPE, String_TYPE, CLASS_TYPE, CLASSLOADER_TYPE}));
            mv.returnValue();
            mv.endMethod();
        }
        super.visitEnd();
    }

    private String getGeneratedMethodName(WeavingData wd) {
        StringBuilder name = new StringBuilder(GENERATED_METHOD_NAME);
        name.append(wd.getClassName().replace('.', '#'));
        name.append("$");
        name.append(wd.getMethodName());
        if (wd.getArgClasses() != null) {
            for (String cls : wd.getArgClasses()) {
                name.append("$");
                name.append(cls.replace('.', '#'));
            }
        }
        return name.toString();
    }

    public boolean additionalImportRequired() {
        return this.additionalImportRequired;
    }

    private class TCCLSetterMethodVisitor
    extends GeneratorAdapter {
        Type lastLDCType;

        public TCCLSetterMethodVisitor(MethodVisitor mv, int access, String name, String descriptor) {
            super(262144, mv, access, name, descriptor);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                this.lastLDCType = (Type)cst;
            }
            super.visitLdcInsn(cst);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            WeavingData wd = this.findWeavingData(owner, name, desc);
            if (opcode == 184 && wd != null) {
                TCCLSetterVisitor.this.additionalImportRequired = true;
                TCCLSetterVisitor.this.woven = true;
                Label startTry = this.newLabel();
                Label endTry = this.newLabel();
                this.visitTryCatchBlock(startTry, endTry, endTry, null);
                this.mark(startTry);
                this.invokeStatic(UTIL_CLASS, new Method("storeContextClassloader", Type.VOID_TYPE, new Type[0]));
                if (ServiceLoader.class.getName().equals(wd.getClassName()) && "load".equals(wd.getMethodName()) && (wd.getArgClasses() == null || Arrays.equals(new String[]{Class.class.getName()}, wd.getArgClasses()))) {
                    this.mv.visitLdcInsn((Object)this.lastLDCType);
                } else {
                    Type type = Type.getObjectType((String)owner);
                    this.mv.visitLdcInsn((Object)type);
                }
                this.invokeStatic(TCCLSetterVisitor.this.targetClass, new Method(TCCLSetterVisitor.this.getGeneratedMethodName(wd), Type.VOID_TYPE, new Type[]{CLASS_TYPE}));
                super.visitMethodInsn(opcode, owner, name, desc);
                Label afterCatch = this.newLabel();
                this.goTo(afterCatch);
                this.mark(endTry);
                this.invokeStatic(UTIL_CLASS, new Method("restoreContextClassloader", Type.VOID_TYPE, new Type[0]));
                this.throwException();
                this.mark(afterCatch);
                this.invokeStatic(UTIL_CLASS, new Method("restoreContextClassloader", Type.VOID_TYPE, new Type[0]));
            } else {
                super.visitMethodInsn(opcode, owner, name, desc);
            }
        }

        private WeavingData findWeavingData(String owner, String methodName, String methodDesc) {
            owner = owner.replace('/', '.');
            Type[] argTypes = Type.getArgumentTypes((String)methodDesc);
            Object[] argClassNames = new String[argTypes.length];
            for (int i = 0; i < argTypes.length; ++i) {
                argClassNames[i] = argTypes[i].getClassName();
            }
            for (WeavingData wd : TCCLSetterVisitor.this.weavingData) {
                if (!wd.getClassName().equals(owner) || !wd.getMethodName().equals(methodName) || wd.getArgClasses() != null && !Arrays.equals(argClassNames, wd.getArgClasses())) continue;
                return wd;
            }
            return null;
        }
    }
}

