/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.xmlparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TreeNode {
    protected HashMap<String, String> attributes = null;
    protected String body = null;
    protected ArrayList<TreeNode> children = null;
    protected String name = null;
    protected TreeNode parent = null;

    public TreeNode(String name) {
        this(name, null);
    }

    public TreeNode(String name, TreeNode parent) {
        this.name = name;
        this.parent = parent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public void addAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public void addChild(TreeNode node) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(node);
    }

    public String findAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public Iterator<String> findAttributes() {
        Set<Object> attrs = this.attributes == null ? Collections.emptySet() : this.attributes.keySet();
        return attrs.iterator();
    }

    public TreeNode findChild(String name) {
        if (this.children == null) {
            return null;
        }
        for (TreeNode item : this.children) {
            if (!name.equals(item.getName())) continue;
            return item;
        }
        return null;
    }

    public Iterator<TreeNode> findChildren() {
        List<Object> nodes = this.children == null ? Collections.emptyList() : this.children;
        return nodes.iterator();
    }

    public Iterator<TreeNode> findChildren(String name) {
        List results;
        if (this.children == null) {
            results = Collections.emptyList();
        } else {
            results = new ArrayList();
            for (TreeNode item : this.children) {
                if (!name.equals(item.getName())) continue;
                results.add(item);
            }
        }
        return results.iterator();
    }

    public String getBody() {
        return this.body;
    }

    public String getName() {
        return this.name;
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public void removeNode(TreeNode node) {
        if (this.children != null) {
            this.children.remove(node);
        }
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, 0, this);
        return sb.toString();
    }

    protected void toString(StringBuilder sb, int indent, TreeNode node) {
        int indent2 = indent + 2;
        int i = 0;
        while (i < indent) {
            sb.append(' ');
            ++i;
        }
        sb.append('<');
        sb.append(node.getName());
        Iterator<String> names = node.findAttributes();
        while (names.hasNext()) {
            sb.append(' ');
            String name = names.next();
            sb.append(name);
            sb.append("=\"");
            String value = node.findAttribute(name);
            sb.append(value);
            sb.append("\"");
        }
        sb.append(">\n");
        String body = node.getBody();
        if (body != null && body.length() > 0) {
            int i2 = 0;
            while (i2 < indent2) {
                sb.append(' ');
                ++i2;
            }
            sb.append(body);
            sb.append("\n");
        }
        Iterator<TreeNode> children = node.findChildren();
        while (children.hasNext()) {
            TreeNode child = children.next();
            this.toString(sb, indent2, child);
        }
        int i3 = 0;
        while (i3 < indent) {
            sb.append(' ');
            ++i3;
        }
        sb.append("</");
        sb.append(node.getName());
        sb.append(">\n");
    }
}

