/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.web.analytics;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.repo.manage.core.CoreService;
import org.eclipse.packagedrone.web.extender.WebExtender;

public class AnalyticsWebExtender
implements WebExtender {
    private CoreService service;
    private static final String CODE_START = "<script>\n(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)})(window,document,'script','//www.google-analytics.com/analytics.js','ga');\n\n";
    private static final String CODE_END = "\n</script>\n";

    public void setService(CoreService service) {
        this.service = service;
    }

    public void processHead(HttpServletRequest request, Writer writer) throws IOException {
        Map data;
        try {
            data = this.service.getCoreNamespacePlainProperties("ga", new String[]{"trackingId", "anonymizeIp", "forceSSL"});
        }
        catch (Exception exception) {
            return;
        }
        String trackingId = (String)data.get("trackingId");
        if (trackingId == null || trackingId.isEmpty()) {
            return;
        }
        boolean anon = Boolean.parseBoolean((String)data.get("anonymizeIp"));
        boolean forceSsl = Boolean.parseBoolean((String)data.get("forceSSL"));
        StringBuilder sb = new StringBuilder(CODE_START);
        sb.append("ga('create', '").append(trackingId).append("', 'auto');\n");
        if (anon) {
            sb.append("ga('set', 'anonymizeIp', true);\n");
        }
        if (forceSsl) {
            sb.append("ga('set', 'forceSSL', true);\n");
        }
        sb.append("ga('send', 'pageview');\n");
        sb.append(CODE_END);
        writer.write(sb.toString());
    }
}

