/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.usage;

import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.eclipse.packagedrone.VersionInformation;
import org.eclipse.packagedrone.repo.manage.usage.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pinger
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(Pinger.class);
    private static final String PING_URL = "http://packagedrone.org/stats/";
    private static final URL URL;
    private final Statistics statistics;

    static {
        URL url = null;
        try {
            url = new URL(PING_URL);
        }
        catch (MalformedURLException malformedURLException) {}
        URL = url;
    }

    public Pinger(Statistics statistics) {
        this.statistics = statistics;
        this.setDaemon(true);
        this.setName("Pinger");
        this.setPriority(1);
    }

    @Override
    public void run() {
        if (URL == null) {
            logger.info("Trouble parsing ping URL: {}", (Object)PING_URL);
            return;
        }
        long start = System.currentTimeMillis();
        logger.debug("Starting ping");
        try {
            try {
                Pinger.performPing(this.statistics);
            }
            catch (Exception e) {
                logger.info("Failed to ping", (Throwable)e);
                logger.debug("Ended ping after {} ms", (Object)(System.currentTimeMillis() - start));
            }
        }
        finally {
            logger.debug("Ended ping after {} ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    protected static void performPing(Statistics statistics) throws Exception {
        URLConnection con = URL.openConnection();
        con.setDoOutput(true);
        con.setUseCaches(false);
        logger.debug("Connection: {}", (Object)con);
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setRequestMethod("POST");
            ((HttpURLConnection)con).setInstanceFollowRedirects(false);
        }
        con.setRequestProperty("Content-type", "text/json");
        con.setRequestProperty("User-agent", VersionInformation.USER_AGENT);
        Throwable throwable = null;
        Object var3_5 = null;
        try (OutputStream out = con.getOutputStream();){
            GsonBuilder gb = new GsonBuilder();
            Gson g = gb.create();
            OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
            g.toJson((Object)statistics, (Appendable)writer);
            writer.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try (InputStream in = con.getInputStream();){
            String result = CharStreams.toString((Readable)new InputStreamReader(in, StandardCharsets.UTF_8));
            logger.debug("Ping result: {}", (Object)result);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

