/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.importer.job.internal;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.packagedrone.job.ErrorInformation;
import org.eclipse.packagedrone.job.JobInstance;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.importer.ImportContext;
import org.eclipse.packagedrone.repo.importer.ImportSubContext;
import org.eclipse.packagedrone.repo.importer.job.ImporterResult;

public abstract class AbstractImportContext
implements ImportContext,
AutoCloseable {
    private final List<ImportEntry> entries = new LinkedList<ImportEntry>();
    private final List<ImportContext.CleanupTask> cleanup = new LinkedList<ImportContext.CleanupTask>();
    private final JobInstance.Context context;
    private final ChannelService service;
    private final String channelId;

    public AbstractImportContext(JobInstance.Context context, ChannelService service, String channelId) {
        this.context = context;
        this.service = service;
        this.channelId = channelId;
    }

    @Override
    public JobInstance.Context getJobContext() {
        return this.context;
    }

    @Override
    public ImportSubContext scheduleImport(InputStream stream, String name, Map<MetaKey, String> providedMetaData) {
        return this.scheduleStream(this.entries, stream, name, providedMetaData);
    }

    @Override
    public ImportSubContext scheduleImport(Path file, boolean deleteAfterImport, String name, Map<MetaKey, String> providedMetaData) {
        return this.scheduleFile(this.entries, file, deleteAfterImport, name, providedMetaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImportSubContext scheduleFile(List<ImportEntry> entries, Path file, boolean deleteAfterImport, String name, Map<MetaKey, String> providedMetaData) {
        FileEntry entry = new FileEntry(file, deleteAfterImport, name, providedMetaData);
        List<ImportEntry> list = entries;
        synchronized (list) {
            entries.add(entry);
        }
        return this.createSubContext(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImportSubContext scheduleStream(List<ImportEntry> entries, InputStream stream, String name, Map<MetaKey, String> providedMetaData) {
        StreamEntry entry = new StreamEntry(stream, name, providedMetaData);
        List<ImportEntry> list = entries;
        synchronized (list) {
            entries.add(entry);
        }
        return this.createSubContext(entry);
    }

    private ImportSubContext createSubContext(final AbstractEntry parentEntry) {
        return new ImportSubContext(){

            @Override
            public ImportSubContext scheduleImport(Path file, boolean deleteAfterImport, String name, Map<MetaKey, String> providedMetaData) {
                return AbstractImportContext.this.scheduleFile(parentEntry.getChildren(), file, deleteAfterImport, name, providedMetaData);
            }

            @Override
            public ImportSubContext scheduleImport(InputStream stream, String name, Map<MetaKey, String> providedMetaData) {
                return AbstractImportContext.this.scheduleStream(parentEntry.getChildren(), stream, name, providedMetaData);
            }
        };
    }

    public ImporterResult process() throws Exception {
        ImporterResult result = new ImporterResult();
        result.setChannelId(this.getChannelId());
        result.setTotalBytes(this.processChildren(result, null, null, this.entries));
        return result;
    }

    private long processChildren(ImporterResult result, ArtifactInformation parent, ImporterResult.Entry parentEntry, List<ImportEntry> children) throws Exception {
        Exception err = null;
        long bytes = 0L;
        for (ImportEntry entry : children) {
            if (err == null) {
                ImporterResult.Entry newEntry;
                try {
                    ArtifactInformation art = parent == null ? this.performRootImport(entry.openStream(), entry.getName(), entry.getProvidedMetaData()) : (ArtifactInformation)this.service.accessCall(ChannelService.By.id((String)this.channelId), ModifiableChannel.class, channel -> channel.getContext().createArtifact(parent.getId(), entry.openStream(), entry.getName(), entry.getProvidedMetaData()));
                    bytes += art.getSize();
                    newEntry = new ImporterResult.Entry(art.getId(), art.getName(), art.getSize());
                    result.getEntries().add(newEntry);
                    bytes += this.processChildren(result, art, newEntry, entry.getChildren());
                }
                catch (Exception e) {
                    err = e;
                    newEntry = new ImporterResult.Entry(entry.getName(), ErrorInformation.createFrom((Throwable)e));
                    result.getEntries().add(newEntry);
                    this.skipChildren(newEntry, entry.getChildren());
                }
                continue;
            }
            ImporterResult.Entry newEntry = new ImporterResult.Entry(entry.getName());
            result.getEntries().add(newEntry);
            this.skipChildren(newEntry, entry.getChildren());
        }
        if (err != null) {
            throw err;
        }
        return bytes;
    }

    private void skipChildren(ImporterResult.Entry parentEntry, List<ImportEntry> children) {
        for (ImportEntry entry : children) {
            parentEntry.getChildren().add(new ImporterResult.Entry(entry.getName()));
        }
    }

    protected abstract String getChannelId();

    protected abstract ArtifactInformation performRootImport(InputStream var1, String var2, Map<MetaKey, String> var3);

    @Override
    public void close() throws Exception {
        LinkedList<Exception> errors = new LinkedList<Exception>();
        try {
            AbstractImportContext.closeEntries(this.entries);
        }
        catch (Exception e) {
            errors.add(e);
        }
        for (ImportContext.CleanupTask task : this.cleanup) {
            try {
                task.cleanup();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        Exception first = (Exception)errors.pollFirst();
        if (first != null) {
            for (Exception e : errors) {
                first.addSuppressed(e);
            }
            throw first;
        }
    }

    protected static void closeEntries(List<ImportEntry> entries) throws Exception {
        LinkedList<Exception> errors = new LinkedList<Exception>();
        for (ImportEntry entry : entries) {
            try {
                entry.close();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            Exception first = (Exception)errors.pollFirst();
            for (Exception ex : errors) {
                first.addSuppressed(ex);
            }
            throw first;
        }
    }

    @Override
    public void addCleanupTask(ImportContext.CleanupTask cleanup) {
        this.cleanup.add(cleanup);
    }

    private static abstract class AbstractEntry
    implements ImportEntry {
        private final String name;
        private final Map<MetaKey, String> providedMetaData;
        private final List<ImportEntry> children = new LinkedList<ImportEntry>();

        public AbstractEntry(String name, Map<MetaKey, String> providedMetaData) {
            this.name = name;
            this.providedMetaData = providedMetaData;
        }

        @Override
        public List<ImportEntry> getChildren() {
            return this.children;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<MetaKey, String> getProvidedMetaData() {
            return this.providedMetaData;
        }

        @Override
        public void close() throws Exception {
            AbstractImportContext.closeEntries(this.children);
        }
    }

    private static class FileEntry
    extends AbstractEntry {
        private final Path file;
        private final boolean deleteAfterImport;
        private BufferedInputStream stream;

        public FileEntry(Path file, boolean deleteAfterImport, String name, Map<MetaKey, String> providedMetaData) {
            super(name, providedMetaData);
            this.file = file;
            this.deleteAfterImport = deleteAfterImport;
        }

        @Override
        public InputStream openStream() throws Exception {
            this.stream = new BufferedInputStream(new FileInputStream(this.file.toFile()));
            return this.stream;
        }

        @Override
        public void close() throws Exception {
            block9: {
                Exception ex = null;
                try {
                    super.close();
                }
                catch (Exception e) {
                    ex = e;
                }
                try {
                    if (this.stream == null) break block9;
                    try {
                        this.stream.close();
                    }
                    catch (Exception e) {
                        if (ex != null) {
                            e.addSuppressed(ex);
                        }
                        throw e;
                    }
                }
                finally {
                    if (this.deleteAfterImport) {
                        Files.deleteIfExists(this.file);
                    }
                }
            }
        }
    }

    private static interface ImportEntry {
        public void close() throws Exception;

        public Map<MetaKey, String> getProvidedMetaData();

        public String getName();

        public InputStream openStream() throws Exception;

        public List<ImportEntry> getChildren();
    }

    private static class StreamEntry
    extends AbstractEntry {
        private final InputStream stream;

        public StreamEntry(InputStream stream, String name, Map<MetaKey, String> providedMetaData) {
            super(name, providedMetaData);
            this.stream = stream;
        }

        @Override
        public InputStream openStream() {
            return this.stream;
        }

        @Override
        public void close() throws Exception {
            Exception ex = null;
            try {
                super.close();
            }
            catch (Exception e) {
                ex = e;
            }
            try {
                this.stream.close();
            }
            catch (Exception e) {
                if (ex != null) {
                    e.addSuppressed(ex);
                }
                throw e;
            }
        }
    }
}

