/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.maven.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.adapter.maven.ChannelData;
import org.eclipse.packagedrone.repo.adapter.maven.internal.MavenHandler;
import org.eclipse.packagedrone.repo.adapter.maven.upload.ArtifactNotFoundException;
import org.eclipse.packagedrone.repo.adapter.maven.upload.ChannelUploadTarget;
import org.eclipse.packagedrone.repo.adapter.maven.upload.ChecksumValidationException;
import org.eclipse.packagedrone.repo.adapter.maven.upload.Uploader;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.servlet.AbstractChannelServiceServlet;
import org.eclipse.packagedrone.repo.web.utils.ChannelCacheHandler;
import org.eclipse.packagedrone.utils.profiler.Profile;
import org.eclipse.scada.utils.lang.Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenServlet
extends AbstractChannelServiceServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(MavenServlet.class);
    private static final MetaKey CHANNEL_KEY = new MetaKey("maven.repo", "channel");
    private static final ChannelCacheHandler HANDLER_REPO_META = new ChannelCacheHandler(new MetaKey("maven.repo", "repo-metadata"));
    private static final ChannelCacheHandler HANDLER_PREFIXES = new ChannelCacheHandler(new MetaKey("maven.repo", "prefixes"));

    private static String makeOperation(HttpServletRequest request) {
        return String.format("MavenServlet|%s|%s", request.getRequestURI(), request.getMethod());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.trace("get request - {}", (Object)request);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Profile.Handle handle = Profile.start((String)MavenServlet.makeOperation(request));){
            this.handleGetRequest(request, response);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void handleGetRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathString = request.getPathInfo();
        if (pathString == null) {
            pathString = "/";
        }
        if ("/".equals(pathString)) {
            MavenServlet.reply(response, 200, "Package Drone Maven 2 Repository Adapter", new Object[0]);
            return;
        }
        ChannelService service = this.getService(request);
        pathString = pathString.replaceAll("^/+", "");
        pathString = pathString.replaceAll("/+$", "");
        String[] toks = pathString.split("/+", 2);
        String channelId = toks[0];
        try {
            service.accessRun(ChannelService.By.nameOrId((String)channelId), ReadableChannel.class, channel -> {
                Holder holder = new Holder();
                try {
                    if (!channel.streamCacheEntry(CHANNEL_KEY, entry -> {
                        holder.value = ChannelData.fromReader(new InputStreamReader(entry.getStream(), StandardCharsets.UTF_8));
                    })) {
                        this.commitNotConfigured(response, channelId);
                        return;
                    }
                }
                catch (Exception e) {
                    logger.warn("Failed to load maven channel data", (Throwable)e);
                    MavenServlet.reply(response, 503, "Corrupt channel data", new Object[0]);
                    return;
                }
                ChannelData channelData = (ChannelData)holder.value;
                if (channelData == null) {
                    logger.debug("No maven channel data: {}", (Object)channel.getId());
                    this.commitNotConfigured(response, channelId);
                    return;
                }
                if (toks.length == 2 && toks[1].equals(".meta/repository-metadata.xml")) {
                    HANDLER_REPO_META.process(channel, request, response);
                    return;
                }
                if (toks.length == 2 && toks[1].equals(".meta/prefixes.txt")) {
                    HANDLER_PREFIXES.process(channel, request, response);
                    return;
                }
                new MavenHandler((ReadableChannel)channel, channelData).handle(toks.length > 1 ? toks[1] : null, request, response);
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            MavenServlet.reply(response, 404, "Channel %s not found", channelId);
            return;
        }
    }

    protected void commitNotConfigured(HttpServletResponse response, String channelId) throws IOException {
        MavenServlet.reply(response, 404, "Channel %s is not configured for providing a Maven 2 repository. Add the Maven Repository aspect!", channelId);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (Profile.Handle handle = Profile.start((String)MavenServlet.makeOperation(request));){
                logger.debug("Request - pathInfo: {} ", (Object)request.getPathInfo());
                this.processPut(request, response, this.getService(request));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void processUpload(ModifiableChannel channel, String path, HttpServletRequest request) throws ChecksumValidationException, IOException {
        Uploader uploader = new Uploader(new ChannelUploadTarget(channel), null);
        uploader.receive(path, (InputStream)request.getInputStream());
    }

    private void processPut(HttpServletRequest request, HttpServletResponse response, ChannelService service) throws Exception {
        String[] toks = request.getPathInfo().split("/+", 3);
        if (toks.length != 3) {
            logger.debug("Upload path: {}", new Object[]{toks});
            MavenServlet.reply(response, 404, "Upload path not found: %s", new Object[]{toks});
            return;
        }
        String channelNameOrId = toks[1];
        String fullName = toks[2];
        logger.debug("Channel: {}, Artifact: {}", (Object)channelNameOrId, (Object)fullName);
        if (!this.authenticate(ChannelService.By.nameOrId((String)channelNameOrId), request, response)) {
            return;
        }
        try {
            service.accessRun(ChannelService.By.nameOrId((String)channelNameOrId), ModifiableChannel.class, channel -> {
                try {
                    this.processUpload((ModifiableChannel)channel, fullName, request);
                    response.setStatus(200);
                }
                catch (ArtifactNotFoundException e) {
                    logger.debug("Artifact not found", (Throwable)e);
                    MavenServlet.reply(response, 200, e.getMessage(), new Object[0]);
                }
                catch (ChecksumValidationException e) {
                    logger.info("Checksum validation failed", (Throwable)e);
                    MavenServlet.reply(response, 406, e.getMessage(), new Object[0]);
                    return;
                }
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            MavenServlet.reply(response, 404, "Channel %s not found", channelNameOrId);
            return;
        }
    }

    private static void reply(HttpServletResponse response, int statusCode, String message, Object ... args) throws IOException {
        response.setStatus(statusCode);
        response.setContentType("text/plain");
        response.getWriter().format(message, args);
    }
}

