/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.maven.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.packagedrone.VersionInformation;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.XmlHelper;
import org.eclipse.packagedrone.repo.adapter.maven.ChannelData;
import org.eclipse.packagedrone.repo.adapter.maven.MavenInformation;
import org.eclipse.packagedrone.repo.aspect.aggregate.AggregationContext;
import org.eclipse.packagedrone.repo.aspect.aggregate.ChannelAggregator;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.manage.system.SitePrefixService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MavenRepositoryChannelAggregator
implements ChannelAggregator {
    private static final Logger logger = LoggerFactory.getLogger(MavenRepositoryChannelAggregator.class);
    private final XmlHelper xml = new XmlHelper();
    private static final String NL = "\n";
    private final SitePrefixService sitePrefixService;

    public MavenRepositoryChannelAggregator(SitePrefixService sitePrefixService) {
        this.sitePrefixService = sitePrefixService;
    }

    public Map<String, String> aggregateMetaData(AggregationContext context) throws Exception {
        Map<String, ArtifactInformation> map = MavenRepositoryChannelAggregator.makeMap(context.getArtifacts());
        HashMap<String, String> result = new HashMap<String, String>();
        ChannelData cs = new ChannelData();
        HashSet<String> groupIds = new HashSet<String>();
        for (ArtifactInformation art : context.getArtifacts()) {
            Set<MavenInformation> infos = MavenRepositoryChannelAggregator.getInfos(art, map);
            if (logger.isDebugEnabled()) {
                logger.debug("Found {} coordinates for {}", (Object)infos.size(), (Object)art);
                for (MavenInformation info : infos) {
                    logger.debug("   {}", (Object)info);
                }
            }
            for (MavenInformation info : infos) {
                try {
                    cs.add(info, art);
                    groupIds.add(info.getGroupId());
                }
                catch (IllegalStateException ex) {
                    logger.debug("Failed to add " + info, (Throwable)ex);
                }
            }
        }
        String json = cs.toJson();
        result.put("channel", json);
        json = cs.toString();
        context.createCacheEntry("channel", "channel.json", "application/json", (InputStream)new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)));
        context.createCacheEntry("repo-metadata", "repository-metadata.xml", "text/xml", stream -> {
            try {
                this.xml.write((Node)this.makeRepoMetaData(context), stream);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        });
        context.createCacheEntry("prefixes", "prefixes.txt", "text/plain", stream -> this.makePrefixes((OutputStream)stream, (Set<String>)groupIds));
        return result;
    }

    private void makePrefixes(OutputStream stream, Set<String> groupIds) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);
        writer.write("## repository-prefixes/2.0\n");
        writer.write("#\n");
        writer.write("# Generated by Package Drone " + VersionInformation.VERSION + NL);
        Object[] groups = groupIds.toArray(new String[groupIds.size()]);
        Arrays.sort(groups);
        Object[] objectArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Object groupId = objectArray[n2];
            writer.write("/");
            writer.write(((String)groupId).replace(".", "/"));
            writer.write(NL);
            ++n2;
        }
        writer.close();
    }

    private Document makeRepoMetaData(AggregationContext context) {
        Document doc = this.xml.create();
        Element root = doc.createElement("repository-metadata");
        doc.appendChild(root);
        XmlHelper.addElement((Element)root, (String)"version", (Object)"1.0.0");
        XmlHelper.addElement((Element)root, (String)"id", (Object)context.getChannelId());
        XmlHelper.addElement((Element)root, (String)"name", (Object)context.getChannelId());
        XmlHelper.addElement((Element)root, (String)"layout", (Object)"maven2");
        XmlHelper.addElement((Element)root, (String)"policy", (Object)"mixed");
        XmlHelper.addElement((Element)root, (String)"url", (Object)this.makeUrl(context.getChannelId()));
        return doc;
    }

    private String makeUrl(String channelId) {
        return String.format("%s/maven/%s", this.sitePrefixService.getSitePrefix(), channelId);
    }

    static Map<String, ArtifactInformation> makeMap(Collection<ArtifactInformation> artifacts) {
        HashMap<String, ArtifactInformation> result = new HashMap<String, ArtifactInformation>(artifacts.size());
        for (ArtifactInformation art : artifacts) {
            result.put(art.getId(), art);
        }
        return result;
    }

    static Set<MavenInformation> getInfos(ArtifactInformation art, Map<String, ArtifactInformation> map) {
        HashSet<MavenInformation> infos = new HashSet<MavenInformation>();
        MavenInformation coords = MavenRepositoryChannelAggregator.parseMavenCoordinates(art.getMetaData(), null);
        if (coords != null) {
            infos.add(coords);
        }
        Collection<ArtifactInformation> pomArts = MavenRepositoryChannelAggregator.findPomArtifacts(art, map);
        for (ArtifactInformation pomArt : pomArts) {
            MavenInformation coords2 = MavenRepositoryChannelAggregator.parseMavenCoordinates(pomArt.getMetaData(), art);
            if (coords2 == null) continue;
            infos.add(coords2);
        }
        return infos;
    }

    private static MavenInformation parseMavenCoordinates(Map<MetaKey, String> metaData, ArtifactInformation refArtifact) {
        MavenInformation info;
        block4: {
            try {
                info = new MavenInformation();
                MetaKeys.bind((Object)info, metaData);
                if (info.getGroupId() != null && info.getArtifactId() != null && info.getVersion() != null) break block4;
                return null;
            }
            catch (Exception e) {
                logger.debug("Failed to parse maven coordinates", (Throwable)e);
                return null;
            }
        }
        if (refArtifact != null) {
            String ext = FilenameUtils.getExtension((String)refArtifact.getName());
            info.setExtension(ext);
        }
        return info;
    }

    private static Collection<ArtifactInformation> findPomArtifacts(ArtifactInformation art, Map<String, ArtifactInformation> artifacts) {
        LinkedList<ArtifactInformation> poms = new LinkedList<ArtifactInformation>();
        MavenRepositoryChannelAggregator.fillPomsFromChildren(poms, art, artifacts);
        return poms;
    }

    private static int fillPomsFromChildren(Collection<ArtifactInformation> poms, ArtifactInformation art, Map<String, ArtifactInformation> artifacts) {
        int cnt = 0;
        for (String childId : art.getChildIds()) {
            String childName;
            ArtifactInformation child = artifacts.get(childId);
            if (child == null || !MavenRepositoryChannelAggregator.isPomFileName(childName = child.getName())) continue;
            poms.add(child);
            ++cnt;
        }
        return cnt;
    }

    private static boolean isPomFileName(String fileName) {
        return "pom.xml".equals(fileName) || "pom".equals(FilenameUtils.getExtension((String)fileName));
    }
}

