/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.common.internal.menu;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestHandler;
import org.eclipse.packagedrone.web.common.internal.table.OsgiTableExtensionManager;
import org.eclipse.packagedrone.web.common.menu.MenuManager;
import org.eclipse.packagedrone.web.common.menu.MenuManagerImpl;
import org.eclipse.packagedrone.web.common.table.TableExtensionManagerRequest;
import org.eclipse.packagedrone.web.interceptor.ModelAndViewInterceptorAdapter;
import org.osgi.framework.InvalidSyntaxException;

public class MenuInterceptor
extends ModelAndViewInterceptorAdapter {
    private MenuManagerImpl menuManager;
    private OsgiTableExtensionManager tableExtensionManager;

    public void activate() throws InvalidSyntaxException {
        this.menuManager = new MenuManagerImpl();
        this.tableExtensionManager = new OsgiTableExtensionManager();
        this.tableExtensionManager.start();
    }

    public void deactivate() {
        if (this.menuManager != null) {
            this.menuManager.close();
            this.menuManager = null;
        }
        if (this.tableExtensionManager != null) {
            this.tableExtensionManager.stop();
            this.tableExtensionManager = null;
        }
    }

    protected void postHandle(HttpServletRequest request, HttpServletResponse response, RequestHandler requestHandler, ModelAndView modelAndView) {
        if (modelAndView != null && !modelAndView.isRedirect()) {
            modelAndView.put("menuManager", (Object)new MenuManager(this.menuManager, request));
            OsgiTableExtensionManager table = this.tableExtensionManager;
            if (table != null && request != null) {
                modelAndView.put("tableExtensionManager", (Object)new TableExtensionManagerRequest(table, request));
            }
        }
    }
}

