/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo;

import java.io.Serializable;

public class MetaKey
implements Comparable<MetaKey>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final String key;

    public MetaKey(String namespace, String key) {
        if (namespace.contains(":")) {
            throw new IllegalArgumentException(String.format("Namespace must not contain ':'", new Object[0]));
        }
        this.namespace = namespace;
        this.key = key;
    }

    private MetaKey(String namespace, String key, boolean checked) {
        this.namespace = namespace;
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetaKey)) {
            return false;
        }
        MetaKey other = (MetaKey)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
    }

    @Override
    public int compareTo(MetaKey o) {
        int rc = this.namespace.compareTo(o.namespace);
        if (rc != 0) {
            return rc;
        }
        return this.key.compareTo(o.key);
    }

    public String toString() {
        return String.valueOf(this.namespace) + ":" + this.key;
    }

    public static MetaKey fromString(String string) {
        int idx = string.indexOf(58);
        if (idx < 1) {
            return null;
        }
        if (idx + 1 >= string.length()) {
            return null;
        }
        return new MetaKey(string.substring(0, idx), string.substring(idx + 1), true);
    }
}

