/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.importer.aether.web;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.eclipse.packagedrone.job.JobHandle;
import org.eclipse.packagedrone.job.JobManager;
import org.eclipse.packagedrone.job.JobRequest;
import org.eclipse.packagedrone.repo.importer.aether.ImportConfiguration;
import org.eclipse.packagedrone.repo.importer.aether.MavenCoordinates;
import org.eclipse.packagedrone.repo.importer.aether.SimpleArtifactConfiguration;
import org.eclipse.packagedrone.repo.importer.aether.web.AetherResult;
import org.eclipse.packagedrone.repo.importer.aether.web.Helper;
import org.eclipse.packagedrone.repo.importer.web.ImportDescriptor;
import org.eclipse.packagedrone.repo.importer.web.ImportRequest;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.utils.xml.XmlToolsFactory;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.packagedrone.web.controller.form.FormData;
import org.eclipse.packagedrone.web.controller.validator.ControllerValidator;
import org.eclipse.packagedrone.web.controller.validator.ValidationContext;
import org.eclipse.packagedrone.web.util.ParameterOverridingRequestWrapper;

@Secured
@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"MANAGER"})
public class ConfigurationController {
    private final GsonBuilder gson = new GsonBuilder();
    private JobManager jobManager;
    private XmlToolsFactory xmlToolsFactory;

    public void setJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    public void setXmlToolsFactory(XmlToolsFactory xmlToolsFactory) {
        this.xmlToolsFactory = xmlToolsFactory;
    }

    @RequestMapping(value={"/import/{token}/aether/start"}, method={RequestMethod.GET})
    public ModelAndView configure(@RequestParameter(value="configuration", required=false) SimpleArtifactConfiguration cfg) {
        HashMap<String, SimpleArtifactConfiguration> model = new HashMap<String, SimpleArtifactConfiguration>();
        if (cfg != null) {
            model.put("command", cfg);
        } else {
            model.put("command", new SimpleArtifactConfiguration());
        }
        return new ModelAndView("configure", model);
    }

    @RequestMapping(value={"/import/{token}/aether/edit"}, method={RequestMethod.POST})
    public ModelAndView configurePost(@RequestParameter(value="configuration") SimpleArtifactConfiguration cfg) {
        HashMap<String, SimpleArtifactConfiguration> model = new HashMap<String, SimpleArtifactConfiguration>();
        model.put("command", cfg);
        return new ModelAndView("configure", model);
    }

    @RequestMapping(value={"/import/{token}/aether/start"}, method={RequestMethod.POST})
    public ModelAndView configurePost(@Valid @FormData(value="command") SimpleArtifactConfiguration data, BindingResult result) {
        HashMap<String, Boolean> model = new HashMap<String, Boolean>();
        model.put("ok", !result.hasErrors());
        return new ModelAndView("configure", model);
    }

    @RequestMapping(value={"/import/{token}/aether/test"}, method={RequestMethod.POST})
    public ModelAndView testImport(@Valid @FormData(value="command") SimpleArtifactConfiguration data, @PathVariable(value="token") String token, BindingResult result, HttpServletRequest request) {
        if (result.hasErrors()) {
            return this.configurePost(data, result);
        }
        HashMap<String, SimpleArtifactConfiguration> model = new HashMap<String, SimpleArtifactConfiguration>();
        model.put("command", data);
        ImportConfiguration imp = new ImportConfiguration();
        imp.setRepositoryUrl(data.getUrl());
        imp.setIncludeSources(data.isIncludeSources());
        imp.setIncludePoms(data.isIncludePoms());
        imp.setIncludeJavadoc(data.isIncludeJavadoc());
        imp.setAllOptional(data.isAllOptional());
        ImportDescriptor desc = ImportDescriptor.fromBase64((String)token);
        if (desc != null && desc.getChannelId() != null && !desc.getChannelId().isEmpty()) {
            imp.setValidationChannelId(desc.getChannelId());
        }
        HashMap<String, String> properties = new HashMap<String, String>(1);
        imp.getCoordinates().addAll(Helper.parse(data.getDependencies(), this.xmlToolsFactory));
        properties.put("simpleConfig", this.gson.create().toJson((Object)data));
        JobRequest jr = new JobRequest(data.isResolveDependencies() ? "org.eclipse.packagedrone.repo.importer.aether.web.resolver" : "org.eclipse.packagedrone.repo.importer.aether.web.tester", this.gson.create().toJson((Object)imp), properties);
        JobHandle job = this.jobManager.startJob(jr);
        model.put("job", (SimpleArtifactConfiguration)job);
        return new ModelAndView("test", model);
    }

    @RequestMapping(value={"/import/{token}/aether/testComplete"}, method={RequestMethod.POST})
    public ModelAndView completeTest(@RequestParameter(value="jobId") String jobId, @PathVariable(value="token") String token) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        JobHandle job = this.jobManager.getJob(jobId);
        model.put("job", job);
        String data = job.getRequest().getData();
        ImportConfiguration cfg = (ImportConfiguration)this.gson.create().fromJson(data, ImportConfiguration.class);
        model.put("configuration", cfg);
        model.put("cfgJson", job.getProperties().get("simpleConfig"));
        if (job != null && job.isFailed()) {
            model.put("error", job.getError());
            return new ModelAndView("testFailed", model);
        }
        AetherResult result = AetherResult.fromJson(job.getResult());
        ImportConfiguration actualCfg = new ImportConfiguration();
        actualCfg.setRepositoryUrl(cfg.getRepositoryUrl());
        actualCfg.setIncludeSources(cfg.isIncludeSources());
        for (AetherResult.Entry entry : result.getArtifacts()) {
            if (!entry.isResolved()) continue;
            actualCfg.getCoordinates().add(entry.getCoordinates());
        }
        model.put("importConfig", this.gson.create().toJson((Object)actualCfg));
        model.put("result", result);
        return new ModelAndView("testResult", model);
    }

    @RequestMapping(value={"/import/{token}/aether/perform"}, method={RequestMethod.POST})
    public void performImport(@PathVariable(value="token") String token, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HashMap<String, String[]> params = new HashMap<String, String[]>(request.getParameterMap());
        ImportConfiguration cfg = (ImportConfiguration)this.gson.create().fromJson(request.getParameter("importConfig"), ImportConfiguration.class);
        Iterator<MavenCoordinates> i = cfg.getCoordinates().iterator();
        while (i.hasNext()) {
            MavenCoordinates coord = i.next();
            String checkValue = request.getParameter(coord.toString());
            if (checkValue != null) continue;
            i.remove();
        }
        params.put("request", new String[]{ImportRequest.toJson((String)"aether", (String)this.gson.create().toJson((Object)cfg))});
        params.put("token", new String[]{token});
        request.getRequestDispatcher("/import/perform").forward((ServletRequest)new ParameterOverridingRequestWrapper(request, params), (ServletResponse)response);
    }

    @ControllerValidator(formDataClass=SimpleArtifactConfiguration.class)
    public void validateImportConfiguration(SimpleArtifactConfiguration cfg, ValidationContext ctx) {
        Collection<MavenCoordinates> result;
        String deps = cfg.getDependencies();
        if (deps != null && !deps.isEmpty() && (result = Helper.parse(deps, this.xmlToolsFactory)) == null) {
            ctx.error("dependencies", "Invalid dependency format");
        }
    }
}

