/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm.aspect;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.eclipse.packagedrone.utils.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegenerationTracker {
    private static final Logger logger = LoggerFactory.getLogger(RegenerationTracker.class);
    private final Consumer<Set<String>> func;
    private final ThreadLocal<LinkedList<Set<String>>> states = ThreadLocal.withInitial(LinkedList::new);

    public RegenerationTracker(Consumer<Set<String>> regenerationFunc) {
        this.func = regenerationFunc;
    }

    public void run(Exceptions.ThrowingRunnable action) {
        this.run(() -> {
            action.run();
            return null;
        });
    }

    public <T> T run(Callable<T> action) {
        logger.trace("Running ...");
        this.states.get().push(new HashSet());
        try {
            T result = action.call();
            LinkedList<Set<String>> state = this.states.get();
            if (state.size() > 1) {
                Iterator i = state.iterator();
                Set mine = (Set)i.next();
                ((Set)i.next()).addAll(mine);
                mine.clear();
            } else {
                this.flushAll();
            }
            T t = result;
            return t;
        }
        catch (Exception e) {
            this.states.get().peek().clear();
            throw new RuntimeException(e);
        }
        finally {
            Set<String> current = this.states.get().poll();
            if (!current.isEmpty()) {
                throw new IllegalStateException("There are still marked artifacts in the finally section");
            }
        }
    }

    private void flushAll() {
        Set<String> current;
        logger.debug("Flush all");
        while (!(current = this.states.get().poll()).isEmpty()) {
            logger.trace("Flush run: {}", current);
            this.states.get().push(new HashSet());
            this.func.accept(current);
        }
        this.states.get().push(Collections.emptySet());
    }

    public void mark(String artifactId) {
        logger.debug("Mark '{}' for regeneration", (Object)artifactId);
        LinkedList<Set<String>> state = this.states.get();
        Set<String> current = state.peek();
        if (current == null) {
            throw new IllegalStateException("No regeneration context");
        }
        current.add(artifactId);
    }

    public boolean isMarked(String artifactId) {
        LinkedList<Set<String>> all = this.states.get();
        for (Set set : all) {
            if (!set.contains(artifactId)) continue;
            return true;
        }
        return false;
    }
}

