/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.CacheEntryInformation;
import org.eclipse.packagedrone.repo.channel.ChannelState;
import org.eclipse.packagedrone.repo.channel.ValidationMessage;
import org.eclipse.packagedrone.repo.channel.apm.ModifyContextImpl;

public class ChannelWriter
implements AutoCloseable {
    private final OutputStream stream;

    public ChannelWriter(OutputStream stream) {
        this.stream = stream;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public void write(ModifyContextImpl context) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(this.stream, StandardCharsets.UTF_8);
        JsonWriter jw = new JsonWriter((Writer)writer);
        jw.setSerializeNulls(true);
        jw.setIndent("  ");
        jw.beginObject();
        ChannelState state = context.getState();
        jw.name("creationTimestamp");
        this.writeTimestamp(jw, state.getCreationTimestamp());
        jw.name("modificationTimestamp");
        this.writeTimestamp(jw, state.getModificationTimestamp());
        jw.name("locked").value(state.isLocked());
        jw.name("aspects").beginObject();
        jw.name("map").beginObject();
        for (Map.Entry<String, String> entry : context.getAspectStates().entrySet()) {
            jw.name(entry.getKey());
            if (entry.getValue() != null) {
                jw.value(entry.getValue());
                continue;
            }
            jw.nullValue();
        }
        jw.endObject();
        jw.endObject();
        jw.name("artifacts").beginObject();
        for (Map.Entry<String, String> entry : context.getArtifacts().entrySet()) {
            jw.name(entry.getKey()).beginObject();
            this.writeArtifact(jw, (ArtifactInformation)entry.getValue());
            jw.endObject();
        }
        jw.endObject();
        jw.name("cacheEntries").beginObject();
        for (Map.Entry<String, String> entry : context.getCacheEntries().entrySet()) {
            jw.name(((MetaKey)entry.getKey()).toString()).beginObject();
            jw.name("name").value(((CacheEntryInformation)entry.getValue()).getName());
            jw.name("size").value(((CacheEntryInformation)entry.getValue()).getSize());
            jw.name("mimeType").value(((CacheEntryInformation)entry.getValue()).getMimeType());
            jw.name("timestamp");
            this.writeTimestamp(jw, ((CacheEntryInformation)entry.getValue()).getTimestamp());
            jw.endObject();
        }
        jw.endObject();
        this.writeValidationMessages(jw, context.getValidationMessages());
        this.writeMetaData("providedMetaData", jw, context.getProvidedMetaData());
        this.writeMetaData("extractedMetaData", jw, context.getExtractedMetaData());
        jw.endObject();
        jw.flush();
    }

    private void writeTimestamp(JsonWriter jw, Instant timestamp) throws IOException {
        if (timestamp != null) {
            jw.value(timestamp.toEpochMilli());
        } else {
            jw.nullValue();
        }
    }

    private void writeValidationMessages(JsonWriter jw, Collection<ValidationMessage> messages) throws IOException {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        jw.name("validationMessages").beginArray();
        for (ValidationMessage msg : messages) {
            jw.beginObject();
            jw.name("aspectId").value(msg.getAspectId());
            jw.name("severity").value(msg.getSeverity().toString());
            jw.name("message").value(msg.getMessage());
            jw.name("artifactIds").beginArray();
            for (String id : msg.getArtifactIds()) {
                jw.value(id);
            }
            jw.endArray();
            jw.endObject();
        }
        jw.endArray();
    }

    private void writeArtifact(JsonWriter jw, ArtifactInformation art) throws IOException {
        jw.name("name").value(art.getName());
        jw.name("size").value(art.getSize());
        jw.name("date");
        this.writeTimestamp(jw, art.getCreationInstant());
        if (art.getParentId() != null) {
            jw.name("parentId").value(art.getParentId());
        }
        if (!art.getChildIds().isEmpty()) {
            jw.name("childIds").beginArray();
            for (String child : art.getChildIds()) {
                jw.value(child);
            }
            jw.endArray();
        }
        if (!art.getFacets().isEmpty()) {
            jw.name("facets").beginArray();
            for (String facet : art.getFacets()) {
                jw.value(facet);
            }
            jw.endArray();
        }
        this.writeValidationMessages(jw, art.getValidationMessages());
        if (art.getVirtualizerAspectId() != null) {
            jw.name("virtualizerAspectId").value(art.getVirtualizerAspectId());
        }
        this.writeMetaData("providedMetaData", jw, art.getProvidedMetaData());
        this.writeMetaData("extractedMetaData", jw, art.getExtractedMetaData());
    }

    private void writeMetaData(String name, JsonWriter jw, Map<MetaKey, String> metadata) throws IOException {
        if (metadata == null || metadata.isEmpty()) {
            return;
        }
        jw.name(name).beginObject();
        for (Map.Entry<MetaKey, String> entry : metadata.entrySet()) {
            if (entry.getValue() == null) continue;
            jw.name(entry.getKey().toString()).value(entry.getValue());
        }
        jw.endObject();
    }
}

