/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm;

import java.util.Date;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.CacheEntryInformation;

public class CacheEntryModel {
    private String name;
    private long size;
    private String mimeType;
    private Date timestamp;

    public CacheEntryModel() {
    }

    public CacheEntryModel(CacheEntryModel other) {
        this.name = other.name;
        this.size = other.size;
        this.mimeType = other.mimeType;
        this.timestamp = new Date(other.timestamp.getTime());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public static CacheEntryInformation toEntry(MetaKey key, CacheEntryModel model) {
        return new CacheEntryInformation(key, model.name, model.size, model.mimeType, model.timestamp.toInstant());
    }

    public static CacheEntryModel fromInformation(CacheEntryInformation entry) {
        CacheEntryModel result = new CacheEntryModel();
        result.setSize(entry.getSize());
        result.setName(entry.getName());
        result.setMimeType(entry.getMimeType());
        result.setTimestamp(entry.getTimestampAsDate());
        return result;
    }
}

