/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.apm.ValidationMessageModel;

public class ArtifactModel {
    private String parentId;
    private Set<String> childIds;
    private String name;
    private long size;
    private Date date;
    private List<ValidationMessageModel> validationMessages;
    private Map<MetaKey, String> providedMetaData;
    private Map<MetaKey, String> extractedMetaData;
    private Set<String> facets;
    private String virtualizerAspectId;

    public ArtifactModel() {
        this.childIds = new CopyOnWriteArraySet<String>();
        this.facets = new CopyOnWriteArraySet<String>();
        this.validationMessages = new LinkedList<ValidationMessageModel>();
        this.providedMetaData = new HashMap<MetaKey, String>();
        this.extractedMetaData = new HashMap<MetaKey, String>();
    }

    public ArtifactModel(ArtifactModel other) {
        this.parentId = other.parentId;
        this.childIds = other.childIds != null ? new CopyOnWriteArraySet<String>(other.childIds) : new CopyOnWriteArraySet();
        this.facets = other.facets != null ? new CopyOnWriteArraySet<String>(other.facets) : new CopyOnWriteArraySet();
        this.name = other.name;
        this.size = other.size;
        this.date = other.date;
        this.validationMessages = new CopyOnWriteArrayList<ValidationMessageModel>(other.validationMessages);
        this.providedMetaData = new HashMap<MetaKey, String>(other.providedMetaData);
        this.extractedMetaData = new HashMap<MetaKey, String>(other.extractedMetaData);
        this.virtualizerAspectId = other.virtualizerAspectId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setChildIds(Set<String> childIds) {
        this.childIds = childIds;
    }

    public Set<String> getChildIds() {
        return this.childIds;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void setValidationMessages(List<ValidationMessageModel> validationMessages) {
        this.validationMessages = validationMessages;
    }

    public List<ValidationMessageModel> getValidationMessages() {
        return this.validationMessages;
    }

    public void setProvidedMetaData(Map<MetaKey, String> providedMetaData) {
        this.providedMetaData = providedMetaData;
    }

    public Map<MetaKey, String> getProvidedMetaData() {
        return this.providedMetaData;
    }

    public void setExtractedMetaData(Map<MetaKey, String> extractedMetaData) {
        this.extractedMetaData = extractedMetaData;
    }

    public Map<MetaKey, String> getExtractedMetaData() {
        return this.extractedMetaData;
    }

    public void setFacets(Set<String> facets) {
        this.facets = facets;
    }

    public Set<String> getFacets() {
        return this.facets;
    }

    public void setVirtualizerAspectId(String virtualizerAspectId) {
        this.virtualizerAspectId = virtualizerAspectId;
    }

    public String getVirtualizerAspectId() {
        return this.virtualizerAspectId;
    }

    public static ArtifactInformation toInformation(String id, ArtifactModel model) {
        List messages = model.getValidationMessages().stream().map(ValidationMessageModel::toMessage).collect(Collectors.toList());
        return new ArtifactInformation(id, model.getParentId(), model.getChildIds(), model.getName(), model.getSize(), model.getDate().toInstant(), model.getFacets(), messages, model.getProvidedMetaData(), model.getExtractedMetaData(), model.getVirtualizerAspectId());
    }

    public static ArtifactInformation toInformation(Map.Entry<String, ArtifactModel> entry) {
        return ArtifactModel.toInformation(entry.getKey(), entry.getValue());
    }

    public static ArtifactModel fromInformation(ArtifactInformation ai) {
        ArtifactModel result = new ArtifactModel();
        result.setFacets(ai.getFacets());
        result.setParentId(ai.getParentId());
        result.setChildIds(new CopyOnWriteArraySet<String>(ai.getChildIds()));
        result.setName(ai.getName());
        result.setSize(ai.getSize());
        result.setDate(new Date(ai.getCreationInstant().toEpochMilli()));
        result.setExtractedMetaData(new HashMap<MetaKey, String>(ai.getExtractedMetaData()));
        result.setProvidedMetaData(new HashMap<MetaKey, String>(ai.getProvidedMetaData()));
        result.setVirtualizerAspectId(ai.getVirtualizerAspectId());
        result.setValidationMessages(ai.getValidationMessages().stream().map(ValidationMessageModel::fromMessage).collect(Collectors.toList()));
        return result;
    }
}

