/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.common.p2.internal;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.aspect.common.p2.P2UnzipAspectFactory;
import org.eclipse.packagedrone.repo.aspect.virtual.Virtualizer;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P2Unzipper
implements Virtualizer {
    private static final Logger logger = LoggerFactory.getLogger(P2Unzipper.class);

    public void virtualize(Virtualizer.Context context) {
        ArtifactInformation ai = context.getArtifactInformation();
        if (!this.isZip(ai)) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(context.getFile().toFile())));){
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    if (entry.getName().startsWith("features/")) {
                        this.processEntry(context, entry, zis);
                        continue;
                    }
                    if (!entry.getName().startsWith("plugins/")) continue;
                    this.processEntry(context, entry, zis);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.debug("Failed to unzip", (Throwable)e);
        }
    }

    private boolean isZip(ArtifactInformation ai) {
        return ai.getName().toLowerCase().endsWith(".zip");
    }

    private void processEntry(Virtualizer.Context context, ZipEntry entry, ZipInputStream zis) {
        String[] segs = entry.getName().split("\\/");
        String name = segs[segs.length - 1];
        HashMap<MetaKey, String> metaData = new HashMap<MetaKey, String>(1);
        metaData.put(P2UnzipAspectFactory.MK_FULL_NAME, entry.getName());
        context.createVirtualArtifact(name, out -> {
            long l = ByteStreams.copy((InputStream)zis, (OutputStream)out);
        }, metaData);
    }
}

