/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.common.osgi;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.aspect.extract.Extractor;
import org.eclipse.packagedrone.repo.utils.osgi.bundle.BundleInformation;
import org.eclipse.packagedrone.repo.utils.osgi.bundle.BundleInformationParser;
import org.eclipse.packagedrone.repo.utils.osgi.feature.FeatureInformation;
import org.eclipse.packagedrone.repo.utils.osgi.feature.FeatureInformationParser;

public class OsgiExtractor
implements Extractor {
    private static final String KEY_NAME_CLASSIFIER = "classifier";
    private static final String KEY_NAME_MANIFEST = "manifest";
    private static final String KEY_NAME_FULL_MANIFEST = "fullManifest";
    private static final String KEY_NAME_VERSION = "version";
    private static final String KEY_NAME_NAME = "name";
    private static final String KEY_NAME_BUNDLE_INFORMATION = "bundle-information";
    private static final String KEY_NAME_FEATURE_INFORMATION = "feature-information";
    private static final String NAMESPACE = "osgi";
    public static final MetaKey KEY_CLASSIFIER = new MetaKey("osgi", "classifier");
    public static final MetaKey KEY_MANIFEST = new MetaKey("osgi", "manifest");
    public static final MetaKey KEY_FULL_MANIFEST = new MetaKey("osgi", "fullManifest");
    public static final MetaKey KEY_VERSION = new MetaKey("osgi", "version");
    public static final MetaKey KEY_NAME = new MetaKey("osgi", "name");
    public static final MetaKey KEY_BUNDLE_INFORMATION = new MetaKey("osgi", "bundle-information");
    public static final MetaKey KEY_FEATURE_INFORMATION = new MetaKey("osgi", "feature-information");

    public void extractMetaData(Extractor.Context context, Map<String, String> metadata) throws Exception {
        this.extractBundleInformation(context, metadata);
        this.extractFeatureInformation(context, metadata);
    }

    private void extractFeatureInformation(Extractor.Context context, Map<String, String> metadata) throws Exception {
        FeatureInformation fi;
        block12: {
            try {
                Throwable throwable = null;
                Object var5_5 = null;
                try (ZipFile zipFile = new ZipFile(context.getPath().toFile());){
                    fi = new FeatureInformationParser(zipFile).parse();
                    if (fi != null) break block12;
                    return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (ZipException zipException) {
                return;
            }
        }
        metadata.put(KEY_NAME_NAME, fi.getId());
        metadata.put(KEY_NAME_VERSION, "" + fi.getVersion());
        metadata.put(KEY_NAME_CLASSIFIER, "eclipse.feature");
        metadata.put("artifactLabel", "Eclipse Feature");
        metadata.put(KEY_NAME_FEATURE_INFORMATION, fi.toJson());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extractBundleInformation(Extractor.Context context, Map<String, String> metadata) throws Exception {
        BundleInformation bi;
        block28: {
            try {
                Throwable throwable = null;
                Object var5_5 = null;
                try {
                    ZipFile zipFile = new ZipFile(context.getPath().toFile());
                    try {
                        Manifest manifest;
                        ZipEntry m = zipFile.getEntry("META-INF/MANIFEST.MF");
                        if (m == null) {
                            return;
                        }
                        Throwable throwable2 = null;
                        Throwable throwable3 = null;
                        try (InputStream is = zipFile.getInputStream(m);){
                            byte[] data = ByteStreams.toByteArray((InputStream)is);
                            metadata.put(KEY_NAME_FULL_MANIFEST, StandardCharsets.UTF_8.decode(ByteBuffer.wrap(data)).toString());
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                                throw throwable2;
                            }
                            if (throwable2 == throwable4) throw throwable2;
                            throwable2.addSuppressed(throwable4);
                            throw throwable2;
                        }
                        throwable3 = null;
                        Object var10_14 = null;
                        try (InputStream is = zipFile.getInputStream(m);){
                            manifest = new Manifest(is);
                        }
                        catch (Throwable throwable5) {
                            if (throwable3 == null) {
                                throwable3 = throwable5;
                                throw throwable3;
                            }
                            if (throwable3 == throwable5) throw throwable3;
                            throwable3.addSuppressed(throwable5);
                            throw throwable3;
                        }
                        bi = new BundleInformationParser(zipFile, manifest).parse();
                        if (bi != null) break block28;
                        return;
                    }
                    catch (Throwable throwable6) {
                        throw throwable6;
                    }
                    finally {
                        if (zipFile == null) return;
                        zipFile.close();
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable == null) {
                        throwable = throwable7;
                        throw throwable;
                    }
                    if (throwable == throwable7) throw throwable;
                    throwable.addSuppressed(throwable7);
                    throw throwable;
                }
            }
            catch (ZipException zipException) {
                return;
            }
        }
        if (!this.validateBundle(context, bi)) {
            return;
        }
        metadata.put(KEY_NAME_NAME, bi.getId());
        metadata.put(KEY_NAME_VERSION, bi.getVersion() != null ? bi.getVersion().toString() : null);
        metadata.put(KEY_NAME_CLASSIFIER, "bundle");
        metadata.put("artifactLabel", "OSGi Bundle");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Manifest mf = new Manifest();
        mf.getMainAttributes().putValue("Bundle-SymbolicName", bi.getId());
        mf.getMainAttributes().putValue("Bundle-Version", bi.getVersion() != null ? bi.getVersion().toString() : null);
        mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mf.write(bos);
        bos.close();
        metadata.put(KEY_NAME_MANIFEST, bos.toString("UTF-8"));
        metadata.put(KEY_NAME_BUNDLE_INFORMATION, bi.toJson());
    }

    private boolean validateBundle(Extractor.Context context, BundleInformation bi) {
        boolean valid = true;
        String bsn = bi.getId();
        if (bsn.contains(",")) {
            context.validationError("Bundle Symbolic Name contains a comma: " + bsn);
            valid = false;
        }
        return valid;
    }
}

