/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.common;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.packagedrone.repo.aspect.ChannelAspect;
import org.eclipse.packagedrone.repo.aspect.ChannelAspectFactory;
import org.eclipse.packagedrone.repo.aspect.extract.Extractor;

public class CoreAspectFactory
implements ChannelAspectFactory {
    private static final String ID = "core";
    private static final String KEY_NAME = "name";
    private static final String KEY_EXT = "extension";
    private static final String KEY_BASENAME = "basename";
    private static final String KEY_ISO_TIMESTAMP = "iso-timestamp";
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public ChannelAspect createAspect() {
        return new ChannelAspectImpl();
    }

    private static void makeMetadata(Extractor.Context context, Map<String, String> metadata) throws IOException {
        metadata.put(KEY_NAME, context.getName());
        metadata.put(KEY_EXT, FilenameUtils.getExtension((String)context.getName()));
        metadata.put(KEY_BASENAME, FilenameUtils.getBaseName((String)context.getName()));
        metadata.put(KEY_ISO_TIMESTAMP, context.getCreationTimestamp().toString());
        metadata.put(KEY_TIMESTAMP, TIMESTAMP_FORMATTER.format(context.getCreationTimestamp().atOffset(ZoneOffset.UTC)));
    }

    private static class ChannelAspectImpl
    implements ChannelAspect {
        private ChannelAspectImpl() {
        }

        public Extractor getExtractor() {
            return new Extractor(){

                public void extractMetaData(Extractor.Context context, Map<String, String> metadata) throws Exception {
                    CoreAspectFactory.makeMetadata(context, metadata);
                }
            };
        }

        public String getId() {
            return CoreAspectFactory.ID;
        }
    }
}

