/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.storage.apm;

import org.eclipse.packagedrone.storage.apm.StorageContext;
import org.eclipse.packagedrone.storage.apm.StorageModelProvider;

public abstract class AbstractSimpleStorageModelProvider<V, W>
implements StorageModelProvider<V, W> {
    private StorageContext context;
    private V viewModel;
    private W writeModel;
    private final Class<W> writeModelClazz;

    public AbstractSimpleStorageModelProvider(Class<V> viewClazz, Class<W> writeClazz) {
        this.writeModelClazz = writeClazz;
    }

    @Override
    public V getViewModel() {
        return this.viewModel;
    }

    @Override
    public void start(StorageContext context) throws Exception {
        this.context = context;
        this.writeModel = this.loadWriteModel(context);
        this.viewModel = this.makeViewModel(this.writeModel);
    }

    @Override
    public void stop() {
    }

    @Override
    public W cloneWriteModel() {
        return this.cloneWriteModel(this.writeModel);
    }

    @Override
    public void persistWriteModel(W writeModel) throws Exception {
        V viewModel = this.makeViewModel(writeModel);
        this.persistWriteModel(this.context, writeModel);
        this.writeModel = writeModel;
        this.viewModel = viewModel;
    }

    @Override
    public V makeViewModel(Object writeModel) {
        return this.makeViewModelTyped(this.writeModelClazz.cast(writeModel));
    }

    protected abstract V makeViewModelTyped(W var1);

    protected abstract W cloneWriteModel(W var1);

    protected abstract void persistWriteModel(StorageContext var1, W var2) throws Exception;

    protected abstract W loadWriteModel(StorageContext var1) throws Exception;
}

