/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.web.breadcrumbs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.packagedrone.web.LinkTarget;

public class Breadcrumbs {
    private final List<Entry> entries;

    public Breadcrumbs(List<Entry> entries) {
        this.entries = Collections.unmodifiableList(entries);
    }

    public Breadcrumbs(Entry ... entries) {
        this.entries = Arrays.asList(entries);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public static Entry create(String label, Class<?> controllerClazz, String methodName) {
        return new Entry(label, LinkTarget.createFromController(controllerClazz, (String)methodName).getUrl());
    }

    public static Entry create(String label, Class<?> controllerClazz, String methodName, Map<String, ?> model) {
        return new Entry(label, LinkTarget.createFromController(controllerClazz, (String)methodName).expand(model).getUrl());
    }

    public static Entry create(String label, Class<?> controllerClazz, String methodName, String key, Object value) {
        return new Entry(label, LinkTarget.createFromController(controllerClazz, (String)methodName).expand(Collections.singletonMap(key, value)).getUrl());
    }

    public static class Entry {
        private final String label;
        private final String target;

        public Entry(String label, String target) {
            this.label = label;
            this.target = target;
        }

        public Entry(String label) {
            this.label = label;
            this.target = null;
        }

        public String getLabel() {
            return this.label;
        }

        public String getTarget() {
            return this.target;
        }

        public boolean isLink() {
            return this.target != null && !this.target.isEmpty();
        }
    }
}

