/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.web.ui;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.manage.core.CoreService;
import org.eclipse.packagedrone.sec.CreateUser;
import org.eclipse.packagedrone.sec.DatabaseUserInformation;
import org.eclipse.packagedrone.sec.web.captcha.CaptchaResult;
import org.eclipse.packagedrone.sec.web.ui.AbstractUserCreationController;
import org.eclipse.packagedrone.sec.web.ui.CaptchaBinder;
import org.eclipse.packagedrone.sec.web.ui.NewPassword;
import org.eclipse.packagedrone.sec.web.ui.RequestEmail;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.controller.ControllerBinder;
import org.eclipse.packagedrone.web.controller.ControllerBinderParameter;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.packagedrone.web.controller.form.FormData;

@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@RequestMapping(value={"/signup"})
public class SignupController
extends AbstractUserCreationController {
    private CoreService coreService;

    public void setCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView signup() {
        if (!this.isSelfRegistrationAllowed()) {
            return new ModelAndView("signup/notAllowed");
        }
        ModelAndView model = new ModelAndView("signup/form");
        model.put("command", (Object)new CreateUser());
        return model;
    }

    private boolean isSelfRegistrationAllowed() {
        return Boolean.parseBoolean(this.coreService.getCoreProperty(new MetaKey("core", "allow-self-registration")));
    }

    @RequestMapping(method={RequestMethod.POST})
    @ControllerBinder(value=CaptchaBinder.class, parameters={@ControllerBinderParameter(key="name", value="captcha")})
    public ModelAndView signupPost(@Valid @FormData(value="command") CreateUser data, BindingResult result, HttpServletRequest request, CaptchaResult captchaResult) {
        if (!this.isSelfRegistrationAllowed()) {
            return new ModelAndView("signup/notAllowed");
        }
        if (result.hasErrors()) {
            HashMap<String, Object> model = new HashMap<String, Object>(2);
            model.put("command", data);
            model.put("duplicateEmail", result.hasMarker("duplicateEmail"));
            return new ModelAndView("signup/form", model);
        }
        DatabaseUserInformation newUser = this.storage.createUser(data, false);
        return new ModelAndView(String.format("signup/success", newUser.getId()));
    }

    @RequestMapping(value={"/verifyEmail"}, method={RequestMethod.GET})
    public ModelAndView verify(@RequestParameter(value="userId") String userId, @RequestParameter(value="token") String token) {
        String error = this.storage.verifyEmail(userId, token);
        if (error == null) {
            return new ModelAndView("signup/emailVerified");
        }
        return new ModelAndView("signup/verificationFailed", "error", (Object)error);
    }

    @RequestMapping(value={"/requestEmail"}, method={RequestMethod.GET})
    public String requestEmail() {
        return "signup/requestEmail";
    }

    @RequestMapping(value={"/requestEmail"}, method={RequestMethod.POST})
    public ModelAndView requestEmailPost(@Valid @FormData(value="command") RequestEmail data, BindingResult result) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (result.hasErrors()) {
            model.put("command", data);
            return new ModelAndView("signup/requestEmail", model);
        }
        String error = this.storage.reRequestEmail(data.getEmail());
        if (error != null) {
            model.put("error", error);
            return new ModelAndView("signup/requestFailed", model);
        }
        return new ModelAndView("signup/emailRequested", model);
    }

    @RequestMapping(value={"/reset"}, method={RequestMethod.GET})
    public ModelAndView resetPassword() {
        return new ModelAndView("signup/reset", "command", (Object)new RequestEmail());
    }

    @RequestMapping(value={"/reset"}, method={RequestMethod.POST})
    public ModelAndView resetPasswordPost(@Valid @FormData(value="command") RequestEmail data, BindingResult binding) {
        if (binding.hasErrors()) {
            return new ModelAndView("signup/reset");
        }
        String error = this.storage.resetPassword(data.getEmail());
        if (error != null) {
            HashMap<String, String> model = new HashMap<String, String>();
            model.put("error", error);
            return new ModelAndView("signup/passwordResetResult", model);
        }
        return new ModelAndView("signup/passwordResetResult");
    }

    @RequestMapping(value={"/newPassword"}, method={RequestMethod.GET})
    public ModelAndView newPassword(@RequestParameter(value="email") String email, @RequestParameter(value="token") String token) {
        NewPassword data = new NewPassword();
        data.setEmail(email);
        data.setToken(token);
        return new ModelAndView("signup/newPassword", "command", (Object)data);
    }

    @RequestMapping(value={"/newPassword"}, method={RequestMethod.POST})
    public ModelAndView newPasswordPost(@Valid @FormData(value="command") NewPassword data, BindingResult binding) {
        if (binding.hasErrors()) {
            return new ModelAndView("signup/newPassword");
        }
        try {
            this.storage.changePassword(data.getEmail(), data.getToken(), data.getPassword());
        }
        catch (Exception e) {
            return CommonController.createError((String)"Password change", (String)"Failed to change password", (Throwable)e);
        }
        return new ModelAndView("signup/passwordChangeResult");
    }
}

