/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.forms.tags;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.jsp.JspException;
import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.packagedrone.web.forms.tags.OptionTagSupport;
import org.eclipse.packagedrone.web.forms.tags.WriterHelper;

public class OptionList
extends OptionTagSupport {
    private static final long serialVersionUID = 1L;
    private Collection<?> items = Collections.emptyList();
    private String itemValue;

    public int doStartTag() throws JspException {
        WriterHelper writer = new WriterHelper(this.pageContext);
        if (this.items != null) {
            for (Object o : this.items) {
                this.renderOption(writer, o);
            }
        }
        return 0;
    }

    protected void renderOption(WriterHelper writer, Object o) throws JspException {
        try {
            String result = BeanUtils.getProperty((Object)o, (String)this.itemValue);
            this.renderOption(writer, result, o, false);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new JspException((Throwable)e);
        }
    }

    protected void renderOption(WriterHelper writer, Object value, Object label, boolean selected) throws JspException {
        writer.write("<option");
        writer.writeAttribute("value", value);
        writer.writeFlagAttribute("selected", this.isSelected(value));
        writer.write(" >");
        writer.writeEscaped(label != null ? "" + label : "" + value);
        writer.write("</option>");
    }

    public void setItems(Collection<?> items) {
        this.items = items;
    }

    public void setItemValue(String itemValue) {
        this.itemValue = itemValue;
    }
}

